[SECURITY.md](https://github.com/user-attachments/files/24032872/SECURITY.md)

# 🔐 Security Policy

Thank you for helping us keep **TadreebLMS** secure and reliable.  
We take the security of our users and contributors seriously and appreciate responsible disclosures.

---

## 🚨 Supported Versions

Security updates apply to the following versions:

| Version | Supported |
|---------|-----------|
| Latest `main` branch | ✅ Active support |
| Tagged releases (v1.x) | ⚠️ Best effort |
| Older versions | ❌ Not supported |

If you are using an outdated version, please update to the latest release.

---

## 🛡️ Reporting a Vulnerability

If you discover a **security vulnerability**, please follow a responsible disclosure process:

### **Do NOT create a public GitHub issue.**

Instead, report the issue privately:

### 📩 Email:
**tadreemlms@gmail.com** 

### Or send a private message via GitHub:
https://github.com/Tadreeb-LMS

When reporting, please include:

- A clear description of the vulnerability  
- Steps to reproduce  
- Potential impact  
- Suggested fix (optional)  
- Supporting screenshots or logs (if applicable)

We will acknowledge your report within **48 hours** and provide a timeline for resolution.

---

## 🧪 Security Best Practices for Developers

When contributing to TadreebLMS, please follow these guidelines:

- Validate and sanitize all user inputs  
- Avoid storing sensitive data in logs  
- Use Laravel’s built‑in security features (CSRF, XSS protection, hashing)  
- Never commit credentials or `.env` files  
- Use secure dependencies and keep them updated  
- Follow OWASP Top 10 principles  

---

## 🔄 Vulnerability Handling Process

1. Report is received privately  
2. Core maintainers investigate and validate  
3. A fix is developed in a private branch  
4. Patch is released as a security update  
5. Advisory is published after fix release  

We may coordinate with the reporter for proof‑of‑fix verification.

---

## 🏅 Recognition

Researchers or contributors who responsibly disclose vulnerabilities may be credited in:

- Release notes  
- Security advisories  
- Contributors page  

(Unless anonymity is requested)

---

## 🤝 Thank You

We appreciate your contribution to keeping **TadreebLMS** safe for everyone.  
Security is a community effort, and your help is valued. ❤️

