<?php $__env->startSection('title', 'My Assessment | ' . app_name()); ?>




<?php $__env->startSection('content'); ?>

<div class="userheading">

    <h4 class=""> <span><?php echo app('translator')->get('My Assignment'); ?></span> </h4>


</div>
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-12">
                    <div class="table-responsive">


                        <table id="myTable" class="table custom-teacher-table table-striped ">
                            <thead>
                                <tr>

                                    <th><?php echo app('translator')->get('labels.general.sr_no'); ?></th>
                                    <th><?php echo app('translator')->get('Test Name'); ?></th>
                                    <th><?php echo app('translator')->get('Assign Date'); ?></th>
                                    <th><?php echo app('translator')->get('Due Date'); ?></th>
                                    <th><?php echo app('translator')->get('Url'); ?></th>
                                    <th><?php echo e(trans('labels.general.score_label')); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                </tr>
                            </thead>

                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>
    <script>
        $(document).ready(function() {
            var route = '<?php echo e(route('user.myassignment.getdata')); ?>';

            $('#myTable').DataTable({
                processing: true,
                serverSide: true,
                iDisplayLength: 10,
                retrieve: true,
                select: { info: false },
                //dom: 'lfBrtip<"actions">',
                buttons: [{
                        extend: 'csv',
                        exportOptions: {
                            columns: ':visible',
                        }
                    },
                    {
                        extend: 'pdf',
                        exportOptions: {
                            columns: ':visible',
                        }
                    },
                    'colvis'
                ],
                ajax: route,
                columns: [

                    {
                        data: "DT_RowIndex",
                        name: 'DT_RowIndex',
                        searchable: false,
                        orderable: false
                    },
                    {
                        data: "assessment_name",
                        name: 'assessment_name'
                    },
                    {
                        data: "created_at",
                        name: 'created_at'
                    },
                    {
                        data: "due_date",
                        name: 'due_date'
                    },
                    {
                        data: "assesment_url",
                        name: 'assesment_url'
                    },
                    {
                        data: "score",
                        name: 'score'
                    },
                    {
                        data: "status",
                        name: 'status'
                    },
                ],
initComplete: function () {
                      let $searchInput = $('#myTable_filter input[type="search"]');
    $searchInput
        .addClass('custom-search')
        .wrap('<div class="search-wrapper position-relative d-inline-block"></div>')
        .after('<i class="fa fa-search search-icon"></i>');

    $('#myTable_length select').addClass('form-select form-select-sm custom-entries');
                },
                createdRow: function(row, data, dataIndex) {
                    $(row).attr('data-entry-id', data.id);
                },
                language: {
                    <?php if(app()->getLocale() == 'ar'): ?>
                        url: '//cdn.datatables.net/plug-ins/1.13.7/i18n/ar.json'
                    <?php else: ?>
                        url: '//cdn.datatables.net/plug-ins/1.13.7/i18n/en-GB.json'
                    <?php endif; ?>
                },
            });

        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/tadreeblms/resources/views/backend/myassignment/index.blade.php ENDPATH**/ ?>