<?php $request = app('Illuminate\Http\Request'); ?>

<?php $__env->startSection('title', __('Learning Pathways') . ' | ' . app_name()); ?>
<?php $__env->startPush('after-styles'); ?>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.css" rel="stylesheet" />
      <style>

    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<div class="pb-3 align-items-center d-flex justify-content-between">
    <h5 ><?php echo app('translator')->get('Learning Pathways'); ?></h5>
    <div >
         <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('learning_pathway_create')): ?>
        <a href="<?php echo e(route('admin.learning-pathways.create')); ?>" class="btn add-btn"><?php echo app('translator')->get('strings.backend.general.app_add_new'); ?></a>
        <?php endif; ?>
    </div>
</div>
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table id="myTable" class="table dt-select custom-teacher-table table-striped">
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('Name'); ?></th>
                            <th><?php echo app('translator')->get('Courses'); ?></th>
                            <th><?php echo app('translator')->get('Description'); ?></th>
                            <th><?php echo app('translator')->get('In Sequence'); ?></th>
                            <th><?php echo app('translator')->get('strings.backend.general.actions'); ?></th>
                        </tr>
                    </thead>

                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script src="<?php echo e(asset('/js/pages/learning-pathway.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/helpers/confirm-modal.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/helpers/load-modal.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Sortable/1.15.6/Sortable.min.js"></script>
    <script src="<?php echo e(asset('/js/helpers/form-submit.js')); ?>"></script>
    <script>
      
    const canEditLearningPathway = <?php echo json_encode(auth()->user()->can('learning_pathway_edit'), 15, 512) ?>;
    const editRouteTemplate = "<?php echo e(route('admin.learning-pathways.edit', ':id')); ?>";
</script>
    </script>
    <script>
        $(function () {
        const dt = $('#myTable').DataTable({
        processing: true,
        serverSide: true,
        iDisplayLength: 10,
        retrieve: true,
        ajax: "<?php echo e(route('admin.learning-pathways.index')); ?>",
        columns: [
            {
                data: "title",
                name: 'title'
            },
            {
                data: "courses",
                name: 'courses'
            },
            {
                data: "description",
                name: 'description'
            },
            {
                data: "in_sequence",
                name: 'in_sequence'
            },
            {
                data: "actions",
                render: function (data, type, row, meta) {

        if (!canEditLearningPathway) {
            return '';
        }

        const editUrl = editRouteTemplate.replace(':id', row.id);

        return `
            <div class="actions d-flex">
                <a class="btn btn-info me-2" href="${editUrl}">
                    <i class="fa fa-edit"></i>
                </a>
            </div>
        `;
    }
            },
        ],
        dom: "<'table-controls'lf>" +
                     "<'table-responsive't>" +
                     "<'d-flex justify-content-between align-items-center mt-3 pagination-responsive'ip><'actions'>",
        initComplete: function () {
                   let $searchInput = $('#myTable_filter input[type="search"]');
        $searchInput
            .addClass('custom-search')
            .wrap('<div class="search-wrapper position-relative d-inline-block"></div>')
            .after('<i class="fa fa-search search-icon"></i>');

        $('#myTable_length select').addClass('form-select form-select-sm custom-entries');
                },
                   
        language:{
            search:""
        }
                
            });

        // <a class="btn btn-info loadModal" href="/user/learning-pathways/manage-users/${row.id}">Manage Users</i></a>   
        $(document).on("pathway_deleted", ".modal", function (event, params) {
            dt.draw();
        });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/tadreeblms/resources/views/backend/learning-pathway/index.blade.php ENDPATH**/ ?>