<?php $__env->startSection('title', __('Assignments').' | '.app_name()); ?>

<?php $__env->startPush('after-styles'); ?>
<style>
.step_assign{
  font-size: 17px;
  font-weight: 600;
  padding-left: 12px;
  border-bottom: 1px solid #e7e7e7;
  padding-bottom: 11px;
  margin-bottom: 25px;
  display: block;
}
.select2-selection__arrow {
    display: none !important;
}
.select2-container--default .select2-selection--single {
        border: 1px solid #ccc !important;
        border-radius: 5px !important;
        /* padding: 4px; */
    }
    .select2-container .select2-selection--single {
    box-sizing: border-box;
    cursor: pointer;
    display: block;
    height: 34px;
    user-select: none;
    -webkit-user-select: none;
}
.select2-container--default .select2-selection--single .select2-selection__rendered {
    color: #444;
    line-height: 30px;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<form method="POST"
      action="<?php echo e(route('admin.assessment_accounts.course-assignment')); ?>"
      enctype="multipart/form-data"
      class="form-horizontal">

<?php echo csrf_field(); ?>

<div class="pb-3 d-flex justify-content-between">
    <h4><?php echo app('translator')->get('Create Assignment'); ?></h4>

    <div>
        <?php if($user_id != NULL): ?>
            <a href="<?php echo e(route('admin.assessment_accounts.account_assignments', $user_id)); ?>"
               class="btn btn-primary"><?php echo app('translator')->get('View Assignments'); ?></a>
        <?php else: ?>
            <a href="<?php echo e(route('admin.assessment_accounts.assignments')); ?>"
               class="btn btn-primary"><?php echo app('translator')->get('View Assignments'); ?></a>
        <?php endif; ?>
    </div>
</div>

<div class="card">
    <div class="card-body">

        <div class="row">
            <div class="col-12">

                <?php if($user_id != NULL): ?>
                    <input type="hidden" name="user_id" value="<?php echo e($user_id); ?>">
                    <input type="hidden" name="user_type" value="2">
                <?php else: ?>
                    <input type="hidden" name="user_type" value="1">
                <?php endif; ?>

                <label class="step-title">
                    Make a New Assignment (Step-1)
                </label>

                
                <div class="form-group row">
                    <label class="col-md-12 form-control-label">Title</label>
                    <div class="col-md-12">
                        <input class="form-control"
                               type="text"
                               name="title"
                               placeholder="Title for assignment"
                               value="<?php echo e(old('title')); ?>"
                               required>
                    </div>
                </div>

                
                <div class="form-group row">
                    <label class="col-md-12 form-control-label">Due Date</label>
                    <div class="col-md-12">
                        <input class="form-control"
                               type="date"
                               name="due_date"
                               value="<?php echo e(old('due_date')); ?>"
                               required>
                    </div>
                </div>

                <label class="step-title">
                    Make a New Assignment (Step-2)
                </label>

                
                <div class="form-group row">
                    <label class="col-md-12 form-control-label">Course Language</label>

                    <div class="col-md-12 custom-select-wrapper">
                        <select class="form-control custom-select-box"
                                name="course_language">
                            <option value="english" selected>English</option>
                            <option value="arabic">Arabic</option>
                        </select>

                        <span class="custom-select-icon" style="right:23px;">
                            <i class="fa fa-chevron-down"></i>
                        </span>
                    </div>
                </div>

                
                <div class="form-group row">
                    <label class="col-md-12 form-control-label">Course</label>

                    <div class="col-md-12 custom-select-wrapper">
                        <select class="form-control custom-select-box select2"
                                name="course_id">
                            <option value="" disabled <?php echo e(old('course_id') ? '' : 'selected'); ?>>
                                Select One Course
                            </option>

                            <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($value->id); ?>"
                                    <?php echo e(old('course_id') == $value->id ? 'selected' : ''); ?>>
                                    <?php echo e($value->title); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>

                        <span class="custom-select-icon" style="right:23px;">
                            <i class="fa fa-chevron-down"></i>
                        </span>
                    </div>
                </div>

                <label class="step-title">
                    Make a New Assignment (Step-3)
                </label>

                <label class="">Assign to...</label>

                
                <div class="form-group row">
                    <label class="col-md-12 form-control-label">Users</label>

                    <div class="col-md-12 custom-select-wrapper">
                        <select name="teachers[]"
                                class="form-control select2 custom-select-box"
                                multiple>
                            <?php $__currentLoopData = $teachers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>"
                                    <?php echo e(collect(old('teachers'))->contains($key) ? 'selected' : ''); ?>>
                                    <?php echo e($name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>

                        <span class="custom-select-icon" style="right:23px;">
                            <i class="fa fa-chevron-down"></i>
                        </span>
                    </div>
                </div>

                
                <p class="mt-3 mb-1">OR</p>

                <div class="row">
                    <label class="col-md-12 form-control-label">Select Department</label>

                    <div class="col-md-12 custom-select-wrapper">
                        <select name="department_id"
                                class="form-control select2 custom-select-box">
                            <option value="">Select One</option>

                            <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($row->id); ?>">
                                    <?php echo e($row->title); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>

                        <span class="custom-select-icon" style="right:23px;">
                            <i class="fa fa-chevron-down"></i>
                        </span>
                    </div>
                </div>

                
                <div class="form-group row mt-3">
                    <label class="col-md-12 form-control-label">Add Custom Message</label>
                    <div class="col-md-12">
                        <input class="form-control"
                               type="text"
                               name="message"
                               id="message">
                    </div>
                </div>

                
                <div class="form-group">
                    <div class="col-12 d-flex justify-content-end pr-0">

                        <a href="<?php echo e(route('admin.assessment_accounts.assignments', $user_id)); ?>"
                           class="btn btn-secondary mr-3">
                            Cancel
                        </a>

                        <button type="submit" class="btn btn-primary">
                            Create
                        </button>

                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

</form>

<?php $__env->stopSection(); ?>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function () {
        $('#course_language').change(function () {
            $.ajax({
                type: 'POST',
                url: '<?php echo e(route("admin.get.courses.by_lang")); ?>',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    'lang':$(this).val()
                },
                datatype: "json",
                success: function (res) {
                    //console.log(res.courses)
                    let $select = $('select[name="course_id"]');
                    $select.empty();
                    $select.append('<option value="" disabled selected>Select One Course</option>');
                    $.each(res.courses, function (index, course) {
                        $select.append(`<option value="${course.id}">${course.title}</option>`);
                    });
                    $select.trigger('change');
                }
            })
            
        })
    });
</script>
<?php $__env->startPush('after-scripts'); ?>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/tadreeblms/resources/views/backend/assessment_accounts/create_assignment_course.blade.php ENDPATH**/ ?>