<?php $__env->startSection('title', app_name() . ' | ' . __('labels.backend.access.users.management')); ?>
<?php $__env->startPush('after-styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/css/colors/switch.css')); ?>">
 <style>
         #myTable {
        table-layout: fixed !important;
        width: 100% !important;
    }
    .dropdown-item{
        border-bottom: none;
    }
    </style>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('breadcrumb-links'); ?>
    <?php echo $__env->make('backend.auth.user.includes.breadcrumb-links', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="pb-3 d-flex justify-content-between align-items-center">
    <h4>
           <?php echo e(__('labels.backend.access.users.management')); ?>

                <small class="text-muted ml-3"><?php echo e(__('labels.backend.access.users.active')); ?></small>
    </h4>
     <div class="">
                   <?php echo $__env->make('backend.auth.user.includes.header-buttons', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
</div>
    <div class="card">
        <div class="card-body">
        

            <div class="row mt-4">
                <div class="col">

                    <div class="table-responsive">
                        <table id="myTable" class="table dt-select custom-teacher-table table-striped" style="width: 2500px;">
                            <thead>
                            <tr>
                                <th style="width: 100px;"><?php echo app('translator')->get('labels.general.sr_no'); ?></th>
                                
                                <th style="width: 100px;"><?php echo app('translator')->get('labels.backend.access.users.table.first_name'); ?></th>
                                <th style="width: 100px;"><?php echo app('translator')->get('labels.backend.access.users.table.last_name'); ?></th>
                                <th style="width: 100px;"><?php echo app('translator')->get('labels.backend.access.users.table.email'); ?></th>
                                <th style="width: 100px;"><?php echo app('translator')->get('labels.backend.access.users.table.confirmed'); ?></th>
                                <th style="width: 100px;"><?php echo app('translator')->get('labels.backend.access.users.table.roles'); ?></th>
                                <th style="width: 130px;"><?php echo app('translator')->get('labels.backend.access.users.table.other_permissions'); ?></th>
                                <th style="width: 100px;"><?php echo app('translator')->get('labels.backend.access.users.table.social'); ?></th>
                                <th style="width: 100px;"><?php echo app('translator')->get('labels.backend.access.users.table.last_updated'); ?></th>
                                <th style="width: 300px;" class="text-center"><?php echo app('translator')->get('labels.general.actions'); ?></th>
                            </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </div>
                </div><!--col-->
            </div><!--row-->

        </div><!--card-body-->
    </div><!--card-->
<?php $__env->stopSection(); ?>


<?php $__env->startPush('after-scripts'); ?>
    <script>

        $(document).ready(function () {
            var route = '<?php echo e(route('admin.auth.user.getData')); ?>';

            var myTable = $('#myTable').DataTable({
                autoWidth: false,
                processing: true,
                serverSide: true,
                iDisplayLength: 10,
                retrieve: true,
                dom: "<'table-controls'lfB>" +
                     "<'table-responsive't>" +
                     "<'d-flex justify-content-between align-items-center mt-3'ip><'actions'>",
                // buttons: [
                //     {
                //         extend: 'csv',
                //         exportOptions: {
                //             columns: [1, 2, 3, 4, 5, 6, 7, 8]
                //         }
                //     },
                //     {
                //         extend: 'pdf',
                //         exportOptions: {
                //             columns: [1, 2, 3, 4, 5, 6, 7, 8]
                //         }
                //     },
                //     'colvis'
                // ],
                buttons: [
    {
        extend: 'collection',
        text: '<i class="fa fa-download icon-styles"></i>',
        className: '',
        buttons: [
            {
                extend: 'csv',
                text: 'CSV',
                exportOptions: {
                    columns: [1, 2, 3, 4, 5]
                }
            },
            {
                extend: 'pdf',
                text: 'PDF',
                exportOptions: {
                    columns: [1, 2, 3, 4, 5]
                }
            }
        ]
    },
      {extend: 'colvis',
    text: '<i class="fa fa-eye icon-styles" aria-hidden="true"></i>',
    className: ''},
],
                ajax: {
                    url: route,
                    data: function (d) {
                        d.role = $('#roles').val();
                    }
                },
                columns: [
                    {data: "DT_RowIndex", name: 'DT_RowIndex', "orderable": false, "searchable": false},
                    // {data: "id", name: 'id', "orderable": false},
                    {data: "first_name", name: 'first_name'},
                    {data: "last_name", name: 'last_name'},
                    {data: "email", name: "email"},
                    {data: "confirmed_label", name: "confirmed_label"},
                    {data: "roles_label", name: "roles.name"},
                    {data: "permissions_label", name: "permissions.name"},
                    {data: "social_buttons", name: "social_accounts.provider", "searchable": false},
                    {data: "last_updated", name: "last_updated"},
                    {data: "actions", name: "actions", "searchable": false}
                ],

  initComplete: function () {
                     let $searchInput = $('#myTable_filter input[type="search"]');
    $searchInput
        .addClass('custom-search')
        .wrap('<div class="search-wrapper position-relative d-inline-block"></div>')
        .after('<i class="fa fa-search search-icon"></i>');

    $('#myTable_length select').addClass('form-select form-select-sm custom-entries');
                },

                createdRow: function (row, data, dataIndex) {
                    $(row).attr('data-entry-id', data.id);
                },
                language: {
                    url: "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/<?php echo e($locale_full_name); ?>.json",
                    buttons: {
                        colvis: '<?php echo e(trans("datatable.colvis")); ?>',
                        pdf: '<?php echo e(trans("datatable.pdf")); ?>',
                        csv: '<?php echo e(trans("datatable.csv")); ?>',
                    },
                   search:"",
                }
            });


            $(document).on('change', '#roles', function (e) {
                myTable.draw();
                e.preventDefault();
            });
        });

    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/tadreeblms/resources/views/backend/auth/user/index.blade.php ENDPATH**/ ?>