<?php $__env->startSection('content'); ?>
<style>
    .permission-blocks {
        display: flex;
        gap: 15px;
    }
</style>
<div class="card">
    <div class="card-header">
        <h5>Edit Role</h5>
        <a href="<?php echo e(route('admin.roles.index')); ?>" class="btn btn-secondary float-end">Back</a>
    </div>

    <div class="card-body">
        <form action="<?php echo e(route('admin.roles.update', $role->id)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="mb-3">
                <label for="name" class="form-label">Role Name</label>
                <input type="text" name="name" id="name" readonly class="form-control" value="<?php echo e($role->name); ?>" required>
            </div>

            <div class="mb-3">
                <h6>Permissions</h6>

                <div class="permission-blocks row">
                <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module => $modulePermissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="mb-2 border p-2 rounded">
                        <strong><?php echo e(ucfirst($module)); ?></strong>
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input select-all" data-module="<?php echo e($module); ?>" id="select_all_<?php echo e($module); ?>">
                            <label class="form-check-label" for="select_all_<?php echo e($module); ?>">Select All</label>
                        </div>

                        <?php $__currentLoopData = $modulePermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $default_permission_checked = ($module === 'backend');
                                $isChecked = $role->permissions->contains('id', $permission->id) || $default_permission_checked;
                            ?>

                            <div class="form-check ms-3">
                                <input type="checkbox"
                                    name="permissions[]"
                                    class="form-check-input permission-<?php echo e($module); ?>"
                                    value="<?php echo e($permission->id); ?>"
                                    id="perm_<?php echo e($permission->id); ?>"
                                    <?php echo e($isChecked ? 'checked' : ''); ?>

                                    <?php echo e($default_permission_checked ? 'disabled' : ''); ?>>

                                
                                <?php if($default_permission_checked): ?>
                                    <input type="hidden" name="permissions[]" value="<?php echo e($permission->id); ?>">
                                <?php endif; ?>

                                <label class="form-check-label" for="perm_<?php echo e($permission->id); ?>">
                                    <?php echo e($permission->name); ?>

                                </label>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <button type="submit" class="btn btn-success">Update Role</button>
        </form>
    </div>
</div>
<?php $__env->startPush('after-scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {

    document.querySelectorAll('.select-all').forEach(function(selectAllCheckbox) {
        selectAllCheckbox.addEventListener('change', function () {

            //alert('hi'); // THIS WILL NOW SHOW ✅

            const module = this.dataset.module;
            const permissions = document.querySelectorAll(
                'input.permission-' + module
            );

            permissions.forEach(cb => cb.checked = this.checked);
        });
    });

});
</script>
<?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>



<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/tadreeblms/resources/views/backend/roles/edit.blade.php ENDPATH**/ ?>