<?php $__env->startSection('title', __('labels.backend.questions.title') . ' | ' . app_name()); ?>
<?php $__env->startPush('after-styles'); ?> 
<style>
      
.select2-container--default .select2-selection--single {
        border: 1px solid #ccc !important;
        border-radius: 5px !important;
        /* padding: 4px; */
    }
    .select2-container .select2-selection--single {
    box-sizing: border-box;
    cursor: pointer;
    display: block;
    height: 34px;
    user-select: none;
    -webkit-user-select: none;
}
.select2-container--default .select2-selection--single .select2-selection__rendered {
    color: #444;
    line-height: 30px;
}
.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 26px;
    position: absolute;
    top: 4px;
    right: 1px;
    width: 20px;
}
.dropdown-item{
    border-bottom: none;
}

    
    </style>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <?php
        use App\Models\Course;
    ?>
    <div class="pb-3 d-flex justify-content-between align-items-center">
   <h4>
      <?php echo app('translator')->get('labels.backend.questions.title'); ?>
   </h4>
   <div >
         <?php if(app('request')->input('test_id')): ?>
           <?php
               $test_id = app('request')->input('test_id');
           ?>
           <a href="<?php echo e(route('admin.test_questions.create')); ?>?test_id=<?php echo e($test_id); ?>"
               class="btn btn-primary"><?php echo app('translator')->get('strings.backend.general.app_add_new'); ?></a>
       <?php else: ?>
           <a href="<?php echo e(route('admin.test_questions.create')); ?>" class="btn add-btn"><?php echo app('translator')->get('strings.backend.general.app_add_new'); ?></a>
       <?php endif; ?>
   </div>
 
</div>
    <div class="card">
        <!-- <div class="card-header">

            <h3 class="page-title d-inline"><?php echo app('translator')->get('labels.backend.questions.title'); ?></h3>
            <div class="float-right">
                <?php if(app('request')->input('test_id')): ?>
                    <?php
                        $test_id = app('request')->input('test_id');
                    ?>
                    <a href="<?php echo e(route('admin.test_questions.create')); ?>?test_id=<?php echo e($test_id); ?>"
                        class="btn btn-success"><?php echo app('translator')->get('strings.backend.general.app_add_new'); ?></a>
                <?php else: ?>
                    <a href="<?php echo e(route('admin.test_questions.create')); ?>" class="btn btn-success"><?php echo app('translator')->get('strings.backend.general.app_add_new'); ?></a>
                <?php endif; ?>
            </div>

        </div> -->



        <div class="card-body">
            <div class="row mb-3">
                <?php
                    $courses = $courses = Course::has('category')
                        ->ofTeacher()
                        ->pluck('title', 'id')
                        ->prepend('Please select', '');
                ?>
                <div class="col-md-12 col-lg-6 form-group mb-3">
                    <!-- <?php echo Form::label('course_id', trans('labels.backend.lessons.fields.course'), ['class' => 'control-label']); ?>

                    <?php echo Form::select('course_id', $courses, request('course_id') ? request('course_id') : old('course_id'), [
                        'class' => 'form-control js-example-placeholder-single select2 ',
                        'id' => 'course_id',
                    ]); ?> -->
                     <label for="course_id" class="control-label">
                    <?php echo e(trans('labels.backend.lessons.fields.course')); ?>

                </label>
                <div class=" custom-select-wrapper">
                    <select name="course_id" id="course_id" class="form-control custom-select-box" required>
                        <option value="">Select Course</option>
                        <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($id); ?>"
                            <?php if(request('course_id')==$id || old('course_id')==$id): ?> selected <?php endif; ?>>
                            <?php echo e($course); ?>

                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <span class="custom-select-icon">
                        <i class="fa fa-chevron-down"></i>
                    </span>
                </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="table-responsive">
                        <table id="myTable"
                            class="table dt-select custom-teacher-table table-striped <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('category_delete')): ?> <?php if(request('show_deleted') != 1): ?> dt-select <?php endif; ?> <?php endif; ?>">
                            <thead>
                                <tr>
                                    <th style="width: 80px;"><?php echo app('translator')->get('Id'); ?></th>
                                    <th style="width: 80px;"><?php echo app('translator')->get('Test'); ?></th>
                                    <th style="width: 130px;"><?php echo app('translator')->get('Question Type'); ?></th>
                                    <th style="width: 80px;"><?php echo app('translator')->get('Question Text'); ?></th>
                                    <th style="width: 80px;"><?php echo app('translator')->get('Marks'); ?></th>
                                    <th style="width: 80px;text-align:center"><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $test_questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($value->id); ?></td>
                                        <td><?php echo e($value->title); ?></td>
                                        <td>
                                            <?php if($value->question_type == 1): ?>
                                                Single Choice
                                            <?php elseif($value->question_type == 2): ?>
                                                Multiple Choice
                                            <?php else: ?>
                                                Short Answer
                                            <?php endif; ?>
                                        </td>
                                        <td><?= $value->question_text ?></td>
                                        <td><?php echo e($value->marks); ?></td>
                                        <!-- <td class="d-flex"><a href="<?php echo e(route('admin.test_questions.edit', $value->id)); ?>"
                                                class="btn btn-xs btn-info mb-1 mr-2"><i class="icon-pencil"></i></a>
                                            <a onclick="return confirm('Are you sure you want to delete?')"
                                                href="<?php echo e(route('admin.test_questions_delete', ['id' => $value->id])); ?>"
                                                class="btn btn-xs btn-danger mb-1"><i class="icon-trash"></i></a>

                                        </td> -->
                                        <td class="text-center">
    <div class="dropdown">
        <a class="dropdown-toggle" href="javascript:void(0);" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <i class="fa fa-ellipsis-v action-icon" ></i>
        </a>
        <div class="dropdown-menu dropdown-menu-right">
            <a href="<?php echo e(route('admin.test_questions.edit', $value->id)); ?>" class="dropdown-item">
                 Edit
            </a>

                                                    <a data-method="delete" 
                                                        data-trans-button-cancel="<?php echo e(__('buttons.general.cancel')); ?>" 
                                                        data-trans-button-confirm="<?php echo e(__('buttons.general.crud.delete')); ?>" 
                                                        data-trans-title="<?php echo e(__('strings.backend.general.are_you_sure')); ?>" 
                                                        class="btn btn-xs btn-danger text-white mb-1" 
                                                        style="cursor:pointer;" 
                                                        onclick="if(confirm('<?php echo e(__('strings.backend.general.are_you_sure')); ?>')) { $(this).find('form').submit(); }">
                                                        
                                                            <i class="fa fa-trash" 
                                                            data-toggle="tooltip" 
                                                            data-placement="top" 
                                                            title="<?php echo e(__('buttons.general.crud.delete')); ?>"></i>

                                                            <form action="<?php echo e(route('admin.test_questions_delete', ['id' => $value->id])); ?>" 
                                                                method="POST" 
                                                                name="delete_item" 
                                                                style="display:none">
                                                                <?php echo csrf_field(); ?>
                                                                <?php echo method_field('GET'); ?>
                                                            </form>
                                                    </a>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>
    <script>
        $(document).ready(function() {
            $('#myTable').dataTable({
                "paginate": true,
                "sort": true,
                "language": {
                    "emptyTable": "No Data Is Available.",
    
                },
                "order": [
                    [0, "desc"]
                ],
                dom: "<'table-controls'lfB>" +
                     "<'table-responsive't>" +
                     "<'d-flex justify-content-between align-items-center mt-3'ip><'actions'>",
                      buttons: [
    {
        extend: 'collection',
        text: '<i class="fa fa-download icon-styles"></i>',
        className: '',
        buttons: [
            {
                extend: 'csv',
                text: 'CSV',
                exportOptions: {
                    columns: [1, 2, 3, 4, 5]
                }
            },
            {
                extend: 'pdf',
                text: 'PDF',
                exportOptions: {
                    columns: [1, 2, 3, 4, 5]
                }
            }
        ]
    },
      {extend: 'colvis',
    text: '<i class="fa fa-eye icon-styles" aria-hidden="true"></i>',
    className: ''},
],
                // buttons: [{
                //         extend: 'csv',
                //         exportOptions: {
                //             columns: [1, 2, 3, 4]
                //         }
                //     },
                //     {
                //         extend: 'pdf',
                //         exportOptions: {
                //             columns: [1, 2, 3, 4]
                //         }
                //     },
                //     'colvis'
                // ],
                language:{
                    search:"",
                },
                initComplete: function () {
                 let $searchInput = $('#myTable_filter input[type="search"]');
    $searchInput
        .addClass('custom-search')
        .wrap('<div class="search-wrapper position-relative d-inline-block"></div>')
        .after('<i class="fa fa-search search-icon"></i>');

    $('#myTable_length select').addClass('form-select form-select-sm custom-entries');
                },
               
            });
        });



        $(document).on('change', '#course_id', function(e) {
            var course_id = $(this).val();
            window.location.href = "<?php echo e(route('admin.test_questions.index')); ?>" + "?course_id=" + course_id
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/tadreeblms/resources/views/backend/test_questions/index.blade.php ENDPATH**/ ?>