<?php $__env->startSection('title', __('labels.backend.lessons.title').' | '.app_name()); ?>

<?php $__env->startPush('after-styles'); ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-datetimepicker/2.5.4/jquery.datetimepicker.min.css" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('plugins/bootstrap-tagsinput/bootstrap-tagsinput.css')); ?>">
    <style>
        .select2-container--default .select2-selection--single {
            height: 35px;
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: 35px;
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: 35px;
        }

        .bootstrap-tagsinput {
            width: 100% !important;
            display: inline-block;
        }

        .bootstrap-tagsinput .tag {
            line-height: 1;
            margin-right: 2px;
            background-color: #2f353a;
            color: white;
            padding: 3px;
            border-radius: 3px;
        }

    </style>

<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <?php echo Form::model($lesson, ['method' => 'PUT', 'route' => ['admin.lessons.update', $lesson->id], 'files' => true,'autocomplete'=>'off']); ?>


    <div class="pb-3 d-flex justify-content-between align-items-center">
        <h4 class=""><?php echo app('translator')->get('labels.backend.lessons.edit'); ?></h4>
        <div class="">
            <a href="<?php echo e(route('admin.lessons.index')); ?>"
               class="btn btn-primary"><?php echo app('translator')->get('labels.backend.lessons.view'); ?></a>
        </div>
    </div>
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-md-12 col-lg-6 form-group">
                  <div for="course_id" class="form-control-label">
        <?php echo e(trans('labels.backend.lessons.fields.course')); ?>

    </div>
    
    <div class="mt-2 custom-select-wrapper">
        <select name="course_id" id="course_id" class="form-control custom-select-box select2">
            <option value="">Select Course</option>
            <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($key); ?>" <?php echo e((old('course_id') == $key || request('course_id') == $key || $lesson->course_id == $key) ? 'selected' : ''); ?>>
                    <?php echo e($course); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <span class="custom-select-icon">
            <i class="fa fa-chevron-down"></i>
        </span>
    </div>
                </div>
                <div class="col-md-12 col-lg-6 form-group">
                    <?php echo Form::label('title', trans('labels.backend.lessons.fields.title').'*', ['class' => 'control-label']); ?>

                    <?php echo Form::text('title', old('title'), ['class' => 'form-control', 'placeholder' => trans('labels.backend.lessons.fields.title'), 'required' => '']); ?>


                </div>

                

            </div>

            <div class="row">
                <div class="col-md-12 col-lg-6 form-group">
                    <?php echo Form::label('slug', trans('labels.backend.lessons.fields.slug'), ['class' => 'control-label']); ?>

                    <?php echo Form::text('slug', old('slug'), ['class' => 'form-control', 'placeholder' => trans('labels.backend.lessons.slug_placeholder')]); ?>

                </div>
                <?php if($lesson->lesson_image): ?>

                    <div class="col-md-12 col-lg-5 form-group">

                        <?php echo Form::label('lesson_image', trans('labels.backend.lessons.fields.lesson_image').' '.trans('labels.backend.lessons.max_file_size'), ['class' => 'control-label']); ?>

                        <?php echo Form::file('lesson_image', ['class' => 'form-control', 'accept' => 'image/jpeg,image/gif,image/png', 'style' => 'margin-top: 4px;']); ?>

                        <?php echo Form::hidden('lesson_image_max_size', 8); ?>

                        <?php echo Form::hidden('lesson_image_max_width', 4000); ?>

                        <?php echo Form::hidden('lesson_image_max_height', 4000); ?>

                    </div>
                    <div class="col-lg-1 col-12 form-group">
                        <a href="<?php echo e(asset('uploads/'.$lesson->lesson_image)); ?>" target="_blank"><img
                                    src="<?php echo e(asset('uploads/'.$lesson->lesson_image)); ?>" height="65px"
                                    width="65px"></a>
                    </div>
                <?php else: ?>
                    <div class="col-md-12 col-lg-6 form-group">

                                <div for="lesson_image" class="control-label mb-2">
                         <?php echo e(trans('labels.backend.lessons.fields.lesson_image')); ?> <?php echo e(trans('labels.backend.lessons.max_file_size')); ?>

                    </div>
                     <div class="custom-file-upload-wrapper">
                            <input type="file" name="image" id="customFileInput" class="custom-file-input">
                            <label for="customFileInput" class="custom-file-label">
                            <i class="fa fa-upload mr-1"></i> Choose a file
                            </label>
                        </div>
                    </div>
                <?php endif; ?>

            </div>

            <div class="row">
                <div class="col-12 form-group">
                    <?php echo Form::label('short_text', trans('labels.backend.lessons.fields.short_text'), ['class' => 'control-label']); ?>

                    <?php echo Form::textarea('short_text', old('short_text'), ['class' => 'form-control ', 'placeholder' => trans('labels.backend.lessons.short_description_placeholder')]); ?>

                </div>
            </div>
            <div class="row">
                <div class="col-12 form-group">
                    <?php echo Form::label('full_text', trans('labels.backend.lessons.fields.full_text'), ['class' => 'control-label']); ?>

                    <?php echo Form::textarea('full_text', old('full_text'), ['class' => 'form-control editor', 'placeholder' => '','id' => 'editor']); ?>

                </div>
            </div>
            <div class="row">
                <div class="col-12 form-group">
                    <?php echo Form::label('downloadable_files', trans('labels.backend.lessons.fields.downloadable_files').' '.trans('labels.backend.lessons.max_file_size'), ['class' => 'control-label']); ?>

                     <div class="custom-file-upload-wrapper">
                            <input type="file" name="image" id="customFileInput" class="custom-file-input">
                            <label for="customFileInput" class="custom-file-label">
                            <i class="fa fa-upload mr-1"></i> Choose a file
                            </label>
                        </div>
                    <!-- <?php echo Form::file('downloadable_files[]', [
                        'multiple',
                        'class' => 'form-control file-upload',
                         'id' => 'downloadable_files',
                        'accept' => "image/jpeg,image/gif,image/png,application/msword,audio/mpeg,application/vnd.ms-excel,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application,application/vnd.openxmlformats-officedocument.presentationml.presentation,application/vnd.ms-powerpoint,application/pdf,video/mp4", 'style' => 'padding: 3px;'

                        ]); ?> -->
                    <div class="photo-block mt-3">
                        <div class="files-list">
                            <?php if(count($lesson->media) > 0): ?>
                                <?php $__currentLoopData = $lesson->media; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $media): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($media->type == 'download_file'): ?>
                                            <p class="form-group">
                                                <a download href="<?php echo e($media->url); ?>"
                                                target="_blank"><?php echo e($media->file_name); ?>

                                                    (<?php echo e($media->size); ?> KB)</a>
                                                <a href="#" data-media-id="<?php echo e($media->id); ?>"
                                                class="btn btn-xs btn-danger delete remove-file"><?php echo app('translator')->get('labels.backend.lessons.remove'); ?></a>
                                            </p>
                                        <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12 form-group">
                    <?php echo Form::label('pdf_files', trans('labels.backend.lessons.fields.add_pdf'), ['class' => 'control-label']); ?>

                    <div class="custom-file-upload-wrapper">
                            <input type="file" name="image" id="customFileInput" class="custom-file-input">
                            <label for="customFileInput" class="custom-file-label">
                            <i class="fa fa-upload mr-1"></i> Choose a file
                            </label>
                        </div>
                    <div class="photo-block mt-3">
                        <div class="files-list">
                            <?php if($lesson->media): ?>
                                
                                <p class="form-group">
                                    
                                    
                                    <?php $__currentLoopData = $lesson->media; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $media): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($media->type == 'lesson_pdf'): ?>
                                        <iframe src="<?php echo e($media->url); ?>" width="100%" height="500px"></iframe>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-12 form-group">
                    <?php echo Form::label('pdf_files', trans('labels.backend.lessons.fields.add_audio'), ['class' => 'control-label']); ?>

                   <div class="custom-file-upload-wrapper">
                            <input type="file" name="image" id="customFileInput" class="custom-file-input">
                            <label for="customFileInput" class="custom-file-label">
                            <i class="fa fa-upload mr-1"></i> Choose a file
                            </label>
                        </div>
                    <div class="photo-block mt-3">
                        <div class="files-list">
                            <?php if($lesson->media): ?>
                                    <?php $__currentLoopData = $lesson->media; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $media): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($media->type == 'lesson_audio'): ?>
                                            <p class="form-group">
                                                <a href="<?php echo e($media->url); ?>"
                                                target="_blank"><?php echo e($media->file_name); ?>

                                                    (<?php echo e($media->size); ?> KB)</a>
                                                <a href="#" data-media-id="<?php echo e($media->id); ?>"
                                                class="btn btn-xs btn-danger delete remove-file"><?php echo app('translator')->get('labels.backend.lessons.remove'); ?></a>
                                                <audio id="player" controls>
                                                    <source src="<?php echo e($media->url); ?>" type="audio/mp3" />
                                                </audio>
                                            </p>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12 form-group">
                    <?php echo Form::label('add_video', trans('labels.backend.lessons.fields.add_video'), ['class' => 'control-label']); ?>

                    <?php echo Form::select('media_type', ['youtube' => 'Youtube','vimeo' => 'Vimeo','upload' => 'Upload','embed' => 'Embed'],($lesson->mediavideo) ? $lesson->mediavideo->type : null,['class' => 'form-control', 'placeholder' => 'Select One','id'=>'media_type' ]); ?>



                    <?php echo Form::text('video', ($lesson->mediavideo) ? $lesson->mediavideo->url : null, ['class' => 'form-control mt-3 d-none', 'placeholder' => trans('labels.backend.lessons.enter_video_url'),'id'=>'video'  ]); ?>




                    <?php echo Form::file('video_file', ['class' => 'form-control mt-3 d-none', 'placeholder' => trans('labels.backend.lessons.enter_video_url'),'id'=>'video_file','accept' =>'video/mp4', 'style' => 'padding: 3px;'  ]); ?>


                    <input type="hidden" name="old_video_file"
                           value="<?php echo e(($lesson->mediavideo && $lesson->mediavideo->type == 'upload') ? $lesson->mediavideo->url  : ""); ?>">

                    
                      
                    <?php if(isset($lesson->mediavideo) && $lesson->mediavideo->type == 'youtube' ): ?>
                        <iframe width="300" height="200"
                            src="<?php echo e($lesson->mediavideo->embed_url); ?>"
                            title="YouTube video player"
                            frameborder="0"
                           >
                        </iframe>
                    <?php endif; ?>

                    <?php if($lesson->mediavideo && ($lesson->mediavideo->type == 'upload')): ?>
                        <video width="300" class="mt-2 d-none video-player" controls>
                            <source src="<?php echo e(($lesson->mediavideo && $lesson->mediavideo->type == 'upload') ? $lesson->mediavideo->url  : ""); ?>"
                                    type="video/mp4">
                            Your browser does not support HTML5 video.
                        </video>
                    <?php endif; ?>


                    <?php echo app('translator')->get('labels.backend.lessons.video_guide'); ?>
                </div>
            </div>
            <div class="form-group row">
                <div class="col-lg-4 col-md-12">
                    <?php echo e(html()->label('Duration')->class('form-control-label')->for('duration')); ?>


                    <div class="">
                       <?php echo Form::text('duration', old('duration'), ['class' => 'form-control', 'placeholder' => 'Duration [minutes]', ]); ?>

                    </div>
                </div>
                <div class="col-lg-4 col-md-12">
                    <?php echo e(html()->label('Lesson Start Date')->class('form-control-label')->for('lesson_start_date')); ?>


                    <div class="">
                       
                       <input type="text" value="<?php echo e(!empty($lesson->lesson_start_date) ? date('Y-m-d H:i',strtotime($lesson->lesson_start_date)):''); ?>" class="form-control date" id="lesson_start_date" name="lesson_start_date"  >
                    </div>
                </div>

                <div class="col-lg-4 col-md-12  form-group" style="margin-top: 30px;">
                    <?php echo Form::hidden('published', 0); ?>

                    <?php echo Form::checkbox('published', 1, old('published'), []); ?>

                    <?php echo Form::label('published', trans('labels.backend.lessons.fields.published'), ['class' => 'control-label control-label font-weight-bold']); ?>

                </div>
            </div>

            

            <div class="row">
                <div class="col-12  text-right  form-group " >
                    <?php echo Form::submit(trans('strings.backend.general.app_update'), ['class' => 'btn  btn-primary pl-4 pr-4']); ?>

                </div>
            </div>
        </div>
    </div>
    <?php echo Form::close(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>
    <script src="<?php echo e(asset('plugins/bootstrap-tagsinput/bootstrap-tagsinput.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-datetimepicker/2.5.4/build/jquery.datetimepicker.full.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('/vendor/unisharp/laravel-ckeditor/ckeditor.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('/vendor/unisharp/laravel-ckeditor/adapters/jquery.js')); ?>"></script>
    <script src="<?php echo e(asset('/vendor/laravel-filemanager/js/lfm.js')); ?>"></script>
    <script>
        $(document).ready(function () {
            //$.datetimepicker.setLocale('pt-BR');
       	    //$('#datetimepicker').datetimepicker();
           $('#lesson_start_date').datetimepicker({
                format:'Y-m-d H:00',
           });
          
       });

        $('.editor').each(function () {

            CKEDITOR.replace($(this).attr('id'), {
                filebrowserImageBrowseUrl: '/laravel-filemanager?type=Images',
                filebrowserImageUploadUrl: '/laravel-filemanager/upload?type=Images&_token=<?php echo e(csrf_token()); ?>',
                filebrowserBrowseUrl: '/laravel-filemanager?type=Files',
                filebrowserUploadUrl: '/laravel-filemanager/upload?type=Files&_token=<?php echo e(csrf_token()); ?>',

                extraPlugins: 'smiley,lineutils,widget,codesnippet,prism,flash,colorbutton,colordialog,codesnippet',
            });

        });
        $(document).ready(function () {
            $(document).on('click', '.delete', function (e) {
                e.preventDefault();
                var parent = $(this).parent('.form-group');
                var confirmation = confirm('<?php echo e(trans('strings.backend.general.are_you_sure')); ?>')
                if (confirmation) {
                    var media_id = $(this).data('media-id');
                    $.post('<?php echo e(route('admin.media.destroy')); ?>', {media_id: media_id, _token: '<?php echo e(csrf_token()); ?>'},
                        function (data, status) {
                            if (data.success) {
                                parent.remove();
                            } else {
                                alert('Something Went Wrong')
                            }
                        });
                }
            })
        });

        var uploadField = $('input[type="file"]');


        $(document).on('change', 'input[name="lesson_image"]', function () {
            var $this = $(this);
            $(this.files).each(function (key, value) {
                // if (value.size > 5000000) {
                //     alert('"' + value.name + '"' + 'exceeds limit of maximum file upload size')
                //     $this.val("");
                // }
            })
        });

        <?php if($lesson->mediavideo): ?>
        <?php if($lesson->mediavideo->type !=  'upload'): ?>
        $('#video').removeClass('d-none').attr('required', true);
        $('#video_file').addClass('d-none').attr('required', false);
        $('.video-player').addClass('d-none');
        <?php elseif($lesson->mediavideo->type == 'upload'): ?>
        $('#video').addClass('d-none').attr('required', false);
        $('#video_file').removeClass('d-none').attr('required', false);
        $('.video-player').removeClass('d-none');
        <?php else: ?>
        $('.video-player').addClass('d-none');
        $('#video_file').addClass('d-none').attr('required', false);
        $('#video').addClass('d-none').attr('required', false);
        <?php endif; ?>
        <?php endif; ?>
        <?php if($mediavideo): ?>
        <?php if($mediavideo->type !=  'upload'): ?>
        $('#video').removeClass('d-none').attr('required', true);
        $('#video_file').addClass('d-none').attr('required', false);
        $('.video-player').addClass('d-none');
        <?php elseif($mediavideo->type == 'upload'): ?>
        $('#video').addClass('d-none').attr('required', false);
        $('#video_file').removeClass('d-none').attr('required', false);
        $('.video-player').removeClass('d-none');
        <?php else: ?>
        $('.video-player').addClass('d-none');
        $('#video_file').addClass('d-none').attr('required', false);
        $('#video').addClass('d-none').attr('required', false);
        <?php endif; ?>
        <?php endif; ?>
        $(document).on('change', '#media_type', function () {
            if ($(this).val()) {
                if ($(this).val() != 'upload') {
                    $('#video').removeClass('d-none').attr('required', true);
                    $('#video_file').addClass('d-none').attr('required', false);
                    $('.video-player').addClass('d-none')
                } else if ($(this).val() == 'upload') {
                    $('#video').addClass('d-none').attr('required', false);
                    $('#video_file').removeClass('d-none').attr('required', true);
                    $('.video-player').removeClass('d-none')
                }
            } else {
                $('#video_file').addClass('d-none').attr('required', false);
                $('#video').addClass('d-none').attr('required', false)
            }
        })

    </script>
    <script>
    document.querySelectorAll('.custom-file-input').forEach(function(input) {
        input.addEventListener('change', function(e) {
            const label = input.nextElementSibling;
            const fileName = e.target.files.length > 0 ? e.target.files[0].name : 'Choose a file';
            label.innerHTML = '<i class="fa fa-upload mr-1"></i> ' + fileName;
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/tadreeblms/resources/views/backend/lessons/edit.blade.php ENDPATH**/ ?>