<?php $__env->startSection('title', 'Feedback' . ' | ' . app_name()); ?>
<?php $__env->startPush('after-styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/css/colors/switch.css')); ?>">
<style>
    .switch.switch-3d.switch-lg {
        width: 40px;
        height: 20px;
    }

    .switch.switch-3d.switch-lg .switch-handle {
        width: 20px;
        height: 20px;
    }


    .dataTables_paginate.paging_simple_numbers {
        width: 44% !important;
    }
    .dropdown-item {
    position: relative;
    padding: 10px 20px;
    border-bottom: none;
}
</style>

<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<div>
    <div
        class="d-flex justify-content-between pb-3 align-items-center">
        <div class="grow">
            <h5 class="text-20">Feedback Questions</h5>
        </div>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('course_create')): ?>
        <div class="">
            <a href="<?php echo e(route('admin.feedback.feedback-question-multiple')); ?>"
                class="btn btn-primary"><?php echo app('translator')->get('strings.backend.general.app_add_new'); ?></a>

        </div>
        <?php endif; ?>

    </div>
    <div class="card" style="border: none;">
        <div class="card-body">
            <div class="">

                <table id="myTable" class="table custom-teacher-table table-striped">
                    <thead>
                        <tr>
                            <th>Id</th>
                            <th>Question Text</th>
                            <th>Question Type</th>
                            <th style="text-align:center;">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $test_questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($value->id); ?></td>
                            <td><?php echo $value->question; ?></td>
                            <td>
                                <?php if($value->question_type == 1): ?>
                                Single Choice
                                <?php elseif($value->question_type == 2): ?>
                                Multiple Choice
                                <?php else: ?>
                                Short Answer
                                <?php endif; ?>
                            </td>
                            <td>
                                
                                <div class="action-pill">
                                    
                              
                                        <a title="Edit" class="" href="<?php echo e(route('admin.feedback_question.edit', ['id' => $value->id])); ?>">
                                            <i class="fa fa-edit" aria-hidden="true"></i>
                                        </a>
                                        <a title="Delete" class="" href="#" onclick="delete_client('<?php echo e($value->id); ?>')">
                                            <i class="fa fa-trash"></i>
                                        </a>
                               
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>


                </table>
            </div>
        </div>
    </div>
</div>



<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>
<!-- <script>
        $(document).ready(function() {



            var route = '<?php echo e(route('admin.feedback_question.get_data')); ?>';

            <?php if(request('show_deleted') == 1): ?>
                route = '<?php echo e(route('admin.feedback_question.get_data', ['show_deleted' => 1])); ?>';
            <?php endif; ?>

            var table = $('#myTable').DataTable({
                processing: true,
                serverSide: true,
                iDisplayLength: 10,
                retrieve: true,
                dom: 'lfBrtip<"actions">',
                buttons: [{
                        extend: 'csv',
                        exportOptions: {
                            columns: [1, 2, 3]
                        }
                    },
                    {
                        extend: 'pdf',
                        exportOptions: {
                            columns: [1, 2, 3],
                        }
                    },
                    'colvis'
                ],
                ajax: route,
                columns: [
                    <?php if(request('show_deleted') != 1): ?>
                        {
                            "data": function(data) {
                                return '<input type="checkbox" class="single" name="id[]" value="' +
                                    data.id + '" />';
                            },
                            "orderable": false,
                            "searchable": false,
                            "name": "id"
                        },
                    <?php endif; ?>
                    // {data: "DT_RowIndex", name: 'DT_RowIndex', searchable: false, orderable:false},
                    {
                        data: "id",
                        name: 'id'
                    },
                    {
                        data: "question",
                        name: 'question'
                    },
                    {
                        data: "question_type",
                        name: 'question_type'
                    },
                    {
                        data: "actions",
                        name: 'actions'
                    }
                ],
                <?php if(request('show_deleted') != 1): ?>
                    columnDefs: [{
                            "width": "5%",
                            "targets": 0
                        },
                        {
                            "className": "text-center",
                            "targets": [0]
                        }
                    ],
                <?php endif; ?>

                createdRow: function(row, data, dataIndex) {
                    $(row).attr('data-entry-id', data.id);
                },
                language: {
                    url: "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/<?php echo e($locale_full_name); ?>.json",
                    buttons: {
                        colvis: '<?php echo e(trans('datatable.colvis')); ?>',
                        pdf: '<?php echo e(trans('datatable.pdf')); ?>',
                        csv: '<?php echo e(trans('datatable.csv')); ?>',
                    }
                }

            });
            <?php if(auth()->user()->isAdmin()): ?>
                $('.actions').html('<a href="' + '<?php echo e(route('admin.teachers.mass_destroy')); ?>' +
                    '" class="btn btn-xs btn-danger js-delete-selected" style="margin-top:0.755em;margin-left: 20px;">Delete selected</a>'
                );
            <?php endif; ?>



        });
    </script> -->

<script>
    $(document).ready(function() {
        $('#myTable').dataTable({
            "paginate": true,
            "sort": true,
            "language": {
                "emptyTable": "No Data Is Available.",
                search: ""
                //                 paginate: {
                //     previous: '<i class="fa fa-angle-left"></i>',
                //     next: '<i class="fa fa-angle-right"></i>'
                // },
            },
            "order": [
                [0, "desc"]
            ],
            dom: "<'table-controls'lfB>" +
                "<'table-responsive't>" +
                "<'d-flex justify-content-between align-items-center mt-3'ip><'actions'>",
            buttons: [{
                    extend: 'collection',
                    text: '<i class="fa fa-download icon-styles"></i>',
                    className: '',
                    buttons: [{
                            extend: 'csv',
                            text: 'CSV',
                            exportOptions: {
                                columns: [1, 2, 3, 4, 5]
                            }
                        },
                        {
                            extend: 'pdf',
                            text: 'PDF',
                            exportOptions: {
                                columns: [1, 2, 3, 4, 5]
                            }
                        }
                    ]
                },
                {
                    extend: 'colvis',
                    text: '<i class="fa fa-eye icon-styles" aria-hidden="" ></i>',
                },
            ],
            // buttons: [{
            //         extend: 'csv',
            //         exportOptions: {
            //             columns: [1, 2, 3, 4]
            //         }
            //     },
            //     {
            //         extend: 'pdf',
            //         exportOptions: {
            //             columns: [1, 2, 3, 4]
            //         }
            //     },
            //     'colvis'
            // ],
            initComplete: function() {
                let $searchInput = $('#myTable_filter input[type="search"]');
                $searchInput
                    .addClass('custom-search')
                    .wrap('<div class="search-wrapper position-relative d-inline-block"></div>')
                    .after('<i class="fa fa-search search-icon"></i>');

                $('#myTable_length select').addClass('form-select form-select-sm custom-entries');
            },


        });
    });
</script>

<script>
    function delete_client(id) {
        $.ajax({
            type: 'post',
            url: "<?php echo e(route('admin.feedback.feedback-question-multiple-delete')); ?>",
            data: ({
                id: id,
                _token: "<?php echo e(csrf_token()); ?>"
            }),
            success: function(response) {
                window.location.replace("<?php echo e(route('admin.feedback_question.index')); ?>");
            },
            error: function(error) {
                console.log(error);
            }
        })

    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/tadreeblms/resources/views/backend/feedback/index.blade.php ENDPATH**/ ?>