<?php $__env->startSection('title', __('labels.backend.lessons.title').' | '.app_name()); ?>

<?php $__env->startSection('content'); ?>

<div class="pb-3">
    <h4 class=""><?php echo app('translator')->get('labels.backend.lessons.title'); ?></h4>
</div>
    <div class="card">
        
        <div class="card-body">
            <div class="row">
                <div class="col-md-12">
                    <table class="table table-bordered table-striped">
                        <tr>
                            <th><?php echo app('translator')->get('labels.backend.lessons.fields.course'); ?></th>
                            <td><?php echo e($lesson->course->title or ''); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->get('labels.backend.lessons.fields.title'); ?></th>
                            <td><?php echo e($lesson->title); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->get('labels.backend.lessons.fields.slug'); ?></th>
                            <td><?php echo e($lesson->slug); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->get('labels.backend.lessons.fields.lesson_image'); ?></th>
                            <td><?php if($lesson->lesson_image): ?><a href="<?php echo e(asset('storage/uploads/' . $lesson->lesson_image)); ?>" target="_blank"><img
                                            src="<?php echo e(asset('storage/uploads/' . $lesson->lesson_image)); ?>" height="100px"/></a><?php endif; ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->get('labels.backend.lessons.fields.short_text'); ?></th>
                            <td><?php echo $lesson->short_text; ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->get('labels.backend.lessons.fields.full_text'); ?></th>
                            <td><?php echo $lesson->full_text; ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->get('labels.backend.lessons.fields.position'); ?></th>
                            <td><?php echo e($lesson->position); ?></td>
                        </tr>
                        <tr>
                            <th>Lesson Start Date</th>
                            <td><?php echo e(!empty($lesson->lesson_start_date) ? date('d-m-Y H:i:s',strtotime($lesson->lesson_start_date)) : '-'); ?></td>
                        </tr>
                        <tr>
                            <th>Duration [Minutes]</th>
                            <td><?php echo e($lesson->duration); ?></td>
                        </tr>

                        <tr>
                            <th><?php echo app('translator')->get('labels.backend.lessons.fields.media_pdf'); ?></th>
                            <td>
                                <?php if($lesson->mediaPDF): ?>
                                <p class="form-group">
                                    <a href="<?php echo e($lesson?->mediaPDF?->url); ?>" target="_blank"><?php echo e($lesson?->mediaPDF?->url); ?></a>
                                </p>
                                <?php else: ?>
                                    <p>No PDF</p>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->get('labels.backend.lessons.fields.media_audio'); ?></th>
                            <td>
                                <?php if($lesson->media != null &&  $lesson->media->count()): ?>
                                
                                <?php $__currentLoopData = $lesson->media; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $media): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($media->type == 'lesson_audio'): ?>
                                        <p class="form-group">
                                            <a href="<?php echo e($media->url); ?>"
                                               target="_blank"><?php echo e($media->url); ?>

                                                (<?php echo e($media->size); ?> KB)</a>
                                        </p>
                                        <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <p>No Audio</p>
                                <?php endif; ?>
                            </td>
                        </tr>

                        <tr>

                            <th><?php echo app('translator')->get('labels.backend.lessons.fields.downloadable_files'); ?></th>
                            <td>
                                <?php if($lesson->downloadableMedia && $lesson->downloadableMedia->count()): ?>
                                    <?php $__currentLoopData = $lesson->downloadableMedia; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $media): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <p class="form-group">
                                            <a href="<?php echo e($media->url); ?>"
                                               target="_blank"><?php echo e($media->url); ?>

                                                (<?php echo e($media->size); ?> KB)</a>
                                        </p>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <p>No Files</p>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->get('labels.backend.lessons.fields.media_video'); ?></th>
                            <td>
                                <?php if($lesson->mediaVideo !=  null ): ?>
                                        <p class="form-group">
                                           <a href="<?php echo e($lesson->mediaVideo->url); ?>" target="_blank"><?php echo e($lesson->mediaVideo->url); ?></a>
                                        </p>
                                <?php else: ?>
                                    <p>No Videos</p>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->get('labels.backend.lessons.fields.published'); ?></th>
                            <td>
                                <?php if($lesson->published): ?>
                                    <span class="badge badge-success">Published</span>
                                <?php else: ?>
                                    <span class="badge badge-secondary">Draft</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    </table>
                </div>
            </div><!-- Nav tabs -->



            <a href="<?php echo e(route('admin.lessons.index')); ?>"
               class="btn cancel-btn"><?php echo app('translator')->get('strings.backend.general.app_back_to_list'); ?></a>
        </div>
        <div>
            
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/tadreeblms/resources/views/backend/lessons/show.blade.php ENDPATH**/ ?>