<!DOCTYPE html>
<?php if (\Illuminate\Support\Facades\Blade::check('langrtl')): ?>
    <html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="rtl">
<?php else: ?>
    <html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<?php endif; ?>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <?php if(config('favicon_image') != ''): ?>
        <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('storage/logos/' . config('favicon_image'))); ?>" />
    <?php endif; ?>
    <title><?php echo $__env->yieldContent('title', app_name()); ?></title>
    <meta name="description" content="<?php echo $__env->yieldContent('meta_description', ''); ?>">
    <meta name="keywords" content="<?php echo $__env->yieldContent('meta_keywords', ''); ?>">

    
    <?php echo $__env->yieldPushContent('before-styles'); ?>

    <!-- Check if the language is set to RTL, so apply the RTL layouts -->
    <!-- Otherwise apply the normal LTR layouts -->

    <link rel="stylesheet" href="<?php echo e(asset('assets/css/owl.carousel.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/flaticon.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/meanmenu.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/video.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/lightbox.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/progess.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/animate.min.css')); ?>">
    
    <link rel="stylesheet" href="<?php echo e(asset('css/frontend.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/fontawesome-all.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('assets/css/responsive.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('assets/css/colors/switch.css')); ?>">
    <link href="<?php echo e(asset('assets/css/colors/color-2.css')); ?>" rel="alternate stylesheet" type="text/css"
        title="color-2">
    <link href="<?php echo e(asset('assets/css/colors/color-3.css')); ?>" rel="alternate stylesheet" type="text/css"
        title="color-3">
    <link href="<?php echo e(asset('assets/css/colors/color-4.css')); ?>" rel="alternate stylesheet" type="text/css"
        title="color-4">
    <link href="<?php echo e(asset('assets/css/colors/color-5.css')); ?>" rel="alternate stylesheet" type="text/css"
        title="color-5">
    <link href="<?php echo e(asset('assets/css/colors/color-6.css')); ?>" rel="alternate stylesheet" type="text/css"
        title="color-6">
    <link href="<?php echo e(asset('assets/css/colors/color-7.css')); ?>" rel="alternate stylesheet" type="text/css"
        title="color-7">
    <link href="<?php echo e(asset('assets/css/colors/color-8.css')); ?>" rel="alternate stylesheet" type="text/css"
        title="color-8">
    <link href="<?php echo e(asset('assets/css/colors/color-9.css')); ?>" rel="alternate stylesheet" type="text/css"
        title="color-9">

    <link href="<?php echo e(asset('/vendor/unisharp/laravel-ckeditor/plugins/codesnippet/lib/highlight/styles/monokai.css')); ?>"
        rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css" />
    <script src="<?php echo e(asset('/vendor/unisharp/laravel-ckeditor/plugins/codesnippet/lib/highlight/highlight.pack.js')); ?>">
    </script>
    <script src="<?php echo e(asset('assets/js/jquery-2.1.4.min.js')); ?>"></script>
    <script>
        // hljs.initHighlightingOnLoad();
    </script>

    <?php echo $__env->yieldContent('css'); ?>
    <?php echo $__env->yieldPushContent('after-styles'); ?>

    <?php if(config('onesignal_status') == 1): ?>
        <?php echo config('onesignal_data'); ?>

    <?php endif; ?>

    <?php if(config('google_analytics_id') != ''): ?>
        <!-- Global site tag (gtag.js) - Google Analytics -->
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(config('google_analytics_id')); ?>"></script>
        <script>
            window.dataLayer = window.dataLayer || [];

            function gtag() {
                dataLayer.push(arguments);
            }
            gtag('js', new Date());

            gtag('config', '<?php echo e(config('google_analytics_id')); ?>');
        </script>
    <?php endif; ?>
    <?php if(!empty(config('custom_css'))): ?>
        <style>
            <?php echo config('custom_css'); ?>

        </style>
    <?php endif; ?>
    <?php if(config('app.locale') == 'ar'): ?>
    <style>
        .owl-nav {
            left: 0 !important;
            top: -90px;
            position: absolute;
        }
    </style>
    <?php endif; ?>
    <script src="/js/helpers/snap-pixel.js"></script>
</head>

<body class="<?php echo e(config('layout_type')); ?>"
    style="direction: <?php echo e(config('app.locale') == 'ar' ? 'rtl' : 'ltr'); ?>; text-align: <?php echo e(config('app.locale') == 'ar' ? 'right' : 'left'); ?>">
    <?php echo $__env->make('backend.includes.loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div id="google_translate_element"></div>
    <div id="app">
        
        <?php echo $__env->make('frontend.layouts.modals.loginModal', ['default_admin_email' => $default_admin_email], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- Start of Header section
        ============================================= -->
        <nav class="navbar navbar-expand-lg navbar-light">
           
                <div class="navbar-header float-left">
                    <a class="navbar-brand text-uppercase" href="<?php echo e(url('/')); ?>">
                        <?php if( isset($site_logo->value) ): ?>
                       <img src="<?php echo e(asset('assets/img/logo.png')); ?>" alt="logo" class="logoimg">
                       <?php else: ?>
                        <img src="<?php echo e(asset('assets/img/logo.png')); ?>" alt="logo" class="logoimg">
                       <?php endif; ?>
                    </a>
                </div>
          
            <button class="navbar-toggler ham-top-space" type="button" data-toggle="collapse"
                data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false"
                aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <?php if(config('locale.status') && count($locales) > 1): ?>
                <div class="nav-item px-3 dropdown">
                    <a class="nav-link dropdown-toggle nav-link" data-toggle="dropdown" href="<?php echo e(url('/')); ?>" role="button"
                        aria-haspopup="true" aria-expanded="false">
                        <span class="d-md-down-none"><?php echo app('translator')->get('menus.language-picker.language'); ?> (<?php echo e(strtoupper(app()->getLocale())); ?>)</span>
                    </a>

                    <?php echo $__env->make('includes.partials.lang', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            <?php endif; ?>
            
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                
                <ul class="navbar-nav ul-li ml-auto sm-rl-space">

                    <?php if($disabled_landing_page == 0): ?>
                        <li class="px-lg-4 hamburger-top-space sm-tb-space">
                            <form action="/search" method="get" id="searchform">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text searchcourse" id="basic-addon1"><i
                                                class="bi bi-search" onclick="submit()"></i></span>
                                    </div>
                                    <input type="text" class="form-control" name="q"
                                        placeholder="<?php echo app('translator')->get('Search for course'); ?>" aria-label="Username" required
                                        aria-describedby="basic-addon1">
                                </div>
                            </form>
                        </li>
                    <?php endif; ?>
                    
                    <?php if(count($custom_menus) > 0): ?>
                        <?php $__currentLoopData = $custom_menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($menu['id'] == $menu['parent']): ?>
                                <?php if(count($menu->subs) == 0): ?>
                                    <li class="">
                                        <a href="<?php echo e(asset($menu->link)); ?>"
                                            class="nav-link <?php echo e(active_class(Active::checkRoute('frontend.user.dashboard'))); ?>"
                                            id="menu-<?php echo e($menu->id); ?>"><?php echo e(config('app.locale') == 'ar' ? $menu->label_ar : $menu->label); ?></a>
                                    </li>
                                <?php else: ?>
                                    <?php if((isset(auth()->user()->employee_type) && auth()->user()->employee_type == 'external') || !auth()->check()): ?>
                                    <li class="menu-item-has-children ul-li-block sm-tb-space"
                                       >
                                        <a
                                            href="#!"><?php echo e(trans('custom-menu.' . $menu_name . '.' . str_slug($menu->label))); ?></a>
                                        <ul class="sub-menu">
                                            <?php $__currentLoopData = $menu->subs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php echo $__env->make('frontend.layouts.partials.dropdown', $item, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </li>
                                    <?php else: ?>
                                    <li class="">
                                        <a class="nav-link"
                                            href="<?php echo e(asset($menu->link)); ?>"><?php echo e(trans('custom-menu.' . $menu_name . '.' . str_slug($menu->label))); ?></a>
                                     </li>
                                    <?php endif; ?>
                                <?php endif; ?>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>

                    <?php if(auth()->check()): ?>
                        <?php if($logged_in_user->hasRole('student')): ?>
                            <li class="sm-tb-space">
                                <a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo app('translator')->get('navs.frontend.dashboard'); ?></a>
                            </li>
                            <li class="sm-tb-space">
                                <a id="logout" href="<?php echo e(route('frontend.auth.logout')); ?>"><i class="fas fa-sign-out-alt"></i></a>
                            </li>
                        <?php else: ?>
                            <li class="menu-item-has-children ul-li-block px-1 sm-tb-space">
                                <a href="#!" class="addminlink"><?php echo e($logged_in_user->name); ?></a>
                                <ul class="sub-menu">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('backend_view')): ?>
                                        <li>
                                            <a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo app('translator')->get('navs.frontend.dashboard'); ?></a>
                                        </li>
                                    <?php endif; ?>

                                    <li>
                                        <a href="<?php echo e(route('frontend.auth.logout')); ?>"><?php echo app('translator')->get('navs.general.logout'); ?></a>
                                    </li>
                                </ul>
                            </li>
                        <?php endif; ?>
                    <?php else: ?>
                        <li class="sm-tb-space">
                            <div class="log-in">
                                <?php if($disabled_landing_page == 0): ?>
                                <a id="openLoginModal" data-target="#myModal" href="#"><?php echo app('translator')->get('navs.general.login'); ?></a>
                                <?php else: ?> 
                                <a href="<?php echo e(route('frontend.auth.login')); ?>"><?php echo app('translator')->get('navs.general.login'); ?></a>
                                <?php endif; ?>
                                

                            </div>
                        </li>
                        <li class="sm-tb-space">
                            <div class="log-in">
                                <a id="openRegisterModal" data-target="#myRegisterModal"
                                    href="#"><?php echo app('translator')->get('SignUp'); ?></a>
                                

                            </div>
                        </li>
                        <?php if($disabled_landing_page == 0): ?>
                            <li class="sm-tb-space">
                                <div class="cart-search float-lg-right ul-li">
                                    <ul class="lock-icon">
                                        <li>
                                            <a href="<?php echo e(route('cart.index')); ?>"><i class="fas fa-shopping-bag"></i>
                                                <?php if(auth()->check() && Cart::session(auth()->user()->id)->getTotalQuantity() != 0): ?>
                                                    <span
                                                        class="badge badge-danger position-absolute"><?php echo e(Cart::session(auth()->user()->id)->getTotalQuantity()); ?></span>
                                                <?php endif; ?>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </li>
                        <?php endif; ?>
                    <?php endif; ?>
                    
                </ul>
               
            </div>
        </nav>

        

        <?php echo $__env->yieldContent('content'); ?>
        <?php echo $__env->make('cookieConsent::index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php if(1): ?>
            <?php echo $__env->make('frontend.layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>

    </div>

    <!-- Scripts -->

    <?php echo $__env->yieldPushContent('before-scripts'); ?>

    <!-- For Js Library -->
    <script src="<?php echo e(asset('assets/js/jquery-2.1.4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/owl.carousel.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jarallax.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.magnific-popup.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/lightbox.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.meanmenu.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/scrollreveal.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.counterup.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/waypoints.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery-ui.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/gmap3.min.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/js/switch.js')); ?>"></script>
    <script type="text/javascript" src="//cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js"></script>
    <script>
        <?php if(request()->has('user') && request('user') == 'admin'): ?>

            $('#myModal').modal('show');
            $('#loginForm').find('#email').val('admin@lms.com')
            $('#loginForm').find('#password').val('secret')
            $('#loginForm').find('button').trigger('click');
        <?php elseif(request()->has('user') && request('user') == 'student'): ?>

            $('#myModal').modal('show');
            $('#loginForm').find('#email').val('student@lms.com')
            $('#loginForm').find('#password').val('secret')
            $('#loginForm').find('button').trigger('click');
        <?php elseif(request()->has('user') && request('user') == 'teacher'): ?>

            $('#myModal').modal('show');
            $('#loginForm').find('#email').val('teacher@lms.com')
            $('#loginForm').find('#password').val('secret')
            $('#loginForm').find('button').trigger('click');
        <?php endif; ?>
    </script>
    <script type="text/javascript">
        $('.main-slider').slick();
    </script>


    <script src="<?php echo e(asset('assets/js/script.js')); ?>"></script>
    <script>
        <?php if(session()->has('show_login') && session('show_login') == true): ?>
            $('#myModal').modal('show');
        <?php endif; ?>
        var font_color = "<?php echo e(config('font_color')); ?>"
        setActiveStyleSheet(font_color);
    </script>
    <script>
        function submit() {
            let form = document.getElementById("searchform");
            form.submit();
        }

        $('#logout').click(function (e) { 
            e.preventDefault();
            localStorage.removeItem('redirect_url');
            window.location.href = $(this).attr('href');
        });
    </script>

    <?php echo $__env->yieldContent('js'); ?>

    <?php echo $__env->yieldPushContent('after-scripts'); ?>

    <?php echo $__env->make('includes.partials.ga', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php if(!empty(config('custom_js'))): ?>
        <script>
            <?php echo config('custom_js'); ?>

        </script>
    <?php endif; ?>

</body>

</html>
<?php /**PATH /var/www/tadreeblms/resources/views/frontend/layouts/app1.blade.php ENDPATH**/ ?>