<?php
use App\Models\Lesson;
?>

<?php $__env->startSection('title', ($course->meta_title) ? $course->meta_title : app_name() ); ?>
<?php $__env->startSection('meta_description', $course->meta_description); ?>
<?php $__env->startSection('meta_keywords', $course->meta_keywords); ?>
<?php
//echo $course->id;
$subscribe_status = CustomHelper::courseStatus($course->id);
//dd($subscribe_status, $course->id);
?>
<?php $__env->startPush('after-styles'); ?>
    <style>
        .leanth-course.go {
            right: 0;
        }
        .video-container iframe{
            max-width: 100%;
        }
        .modal-dialog {
    max-width: 50rem;
    margin: 1.75rem auto;
}

    </style>
    <link rel="stylesheet" href="https://cdn.plyr.io/3.5.3/plyr.css"/>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

    <!-- Start of breadcrumb section
        ============================================= -->
    <section id="breadcrumb" class="breadcrumb-section relative-position backgroud-style">
        <div class="blakish-overlay"></div>
        <div class="container">
            <div class="page-breadcrumb-content text-center">
                <div class="page-breadcrumb-title">
                    <h2 class="breadcrumb-head black bold"><span><?php echo e($course->title); ?> </span></h2>
                </div>
            </div>
        </div>
    </section>
    <!-- End of breadcrumb section
        ============================================= -->

    <!-- Start of course details section
        ============================================= -->
    <section id="course-details" class="course-details-section">
        <div class="container">
            <div class="row">
                <div class="col-md-9">
                    <?php if(session()->has('danger')): ?>
                        <div class="alert alert-dismissable alert-danger fade show">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            <?php echo session('danger'); ?>

                        </div>
                    <?php endif; ?>
                    <?php if(session()->has('success')): ?>
                        <div class="alert alert-dismissable alert-success fade show">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>
                    <div class="course-details-item border-bottom-0 mb-0">
                        <div class="course-single-pic mb30">
                            <?php if($course->course_image != ""): ?>
                                <img src="<?php echo e(asset('storage/uploads/'.$course->course_image)); ?>"
                                     alt="">
                            <?php endif; ?>
                        </div>
                        <div class="course-single-text">
                            <div class="course-title mt10 headline relative-position">
                                <h3><a href="<?php echo e(route('courses.show', [$course->slug])); ?>"><b><?php echo e($course->title); ?></b></a>
                                    <?php if($course->trending == 1): ?>
                                        <span class="trend-badge text-uppercase bold-font"><i
                                                    class="fas fa-bolt"></i> <?php echo app('translator')->get('labels.frontend.badges.trending'); ?></span>
                                    <?php endif; ?>

                                </h3>
                            </div>
                            <div class="course-details-content">
                                <p>
                                    <?php echo $course->description; ?>

                                </p>
                            </div>
                            <?php if($course->mediaVideo && $course->mediavideo->count() > 0): ?>
                                <div class="course-single-text" style="display:none">
                                    <?php if($course->mediavideo != ""): ?>
                                        <div class="course-details-content mt-3">
                                            <div class="video-container mb-5" data-id="<?php echo e($course->mediavideo->id); ?>">
                                                <?php if($course->mediavideo->type == 'youtube'): ?>


                                                    <div id="player" class="js-player" data-plyr-provider="youtube"
                                                         data-plyr-embed-id="<?php echo e($course->mediavideo->file_name); ?>"></div>
                                                <?php elseif($course->mediavideo->type == 'vimeo'): ?>
                                                    <div id="player" class="js-player" data-plyr-provider="vimeo"
                                                         data-plyr-embed-id="<?php echo e($course->mediavideo->file_name); ?>"></div>
                                                <?php elseif($course->mediavideo->type == 'upload'): ?>
                                                    <video poster="" id="player" class="js-player" playsinline controls>
                                                        <source src="<?php echo e($course->mediavideo->url); ?>" type="video/mp4"/>
                                                    </video>
                                                <?php elseif($course->mediavideo->type == 'embed'): ?>
                                                    <?php echo $course->mediavideo->url; ?>

                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>


                            <?php if(count($lessons)  > 0): ?>

                                <div class="course-details-category ul-li">
                                    <span class="float-none"><?php echo app('translator')->get('labels.frontend.course.course_timeline'); ?></span>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <!-- /course-details -->

                    <div class="affiliate-market-guide mb65">

                        <div class="affiliate-market-accordion">
                            <div id="accordion" class="panel-group">
                                <?php if(count($lessons)  > 0): ?>
                                    <?php $count = 0; ?>
                                    <?php $__currentLoopData = $lessons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $lesson): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($lesson->model && $lesson->model->published == 1): ?>
                                            <?php $count++ ?>
                                            <div class="panel position-relative">
                                                <?php if(auth()->check()): ?>
                                                    <?php if(in_array($lesson->model->id,$completed_lessons)): ?>
                                                        <div class="position-absolute" style="right: 0;top:0px">
                                                            <span class="gradient-bg p-1 text-white font-weight-bold completed"><?php echo app('translator')->get('labels.frontend.course.completed'); ?></span>
                                                        </div>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                                <div class="panel-title" id="headingOne">
                                                    <div class="ac-head">
                                                        <button class="btn btn-link collapsed" data-toggle="collapse"
                                                                data-target="#collapse<?php echo e($count); ?>" aria-expanded="false"
                                                                aria-controls="collapse<?php echo e($count); ?>">
                                                            <span><?php echo e(sprintf("%02d", $count)); ?></span>
                                                            <?php echo e($lesson->model->title); ?>

                                                        </button>
                                                        <?php if($lesson->model_type == 'App\Models\Test'): ?>
                                                            <div class="leanth-course">
                                                                <span><?php echo app('translator')->get('labels.frontend.course.test'); ?></span>
                                                            </div>
                                                        <?php endif; ?>
                                                        
                                                    </div>
                                                </div>
                                                <div id="collapse<?php echo e($count); ?>" class="collapse" aria-labelledby="headingOne"
                                                     data-parent="#accordion">
                                                    <div class="panel-body">
                                                        <?php if($lesson->model_type == 'App\Models\Test'): ?>
                                                            <?php echo e(mb_substr($lesson->model->description,0,20).'...'); ?>

                                                        <?php else: ?>
                                                            <?php if($lesson->model->live_lesson): ?>
                                                            <?php echo e(mb_substr($lesson->model->short_text,0,20).'...'); ?>

                                                            <?php else: ?>
                                                            <?php echo e($lesson->model->short_text); ?>

                                                            <?php endif; ?>

                                                        <?php endif; ?>
                                                        
                                                        <?php if(auth()->check()): ?>

                                                            <?php if(in_array($lesson->model->id,$completed_lessons)): ?>
                                                                <div >
                                                                    <a class="btn btn-warning mt-3"
                                                                       href="<?php echo e(route('lessons.show',['course_id' => $lesson->course->id,'slug'=>$lesson->model->slug])); ?>">
                                                                        <span class=" text-white font-weight-bold "><?php echo app('translator')->get('labels.frontend.course.go'); ?>
                                                                            ></span>
                                                                    </a>
                                                                </div>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </div>






<?php

    $lesson1 = Lesson::findOrFail($lesson->model->id);
    //echo '<pre>';print_r($lesson1->mediavideo);die;
    ?>
    <?php if(!empty($lesson1->mediavideo)): ?>
    <div class="video-container" data-id="<?php echo e($lesson1->mediavideo->id); ?>" style="display:none">
    <?php if($lesson1->mediavideo->type == 'youtube'): ?>
    <div id="player" class="js-player" data-plyr-provider="youtube"
    data-plyr-embed-id="<?php echo e($lesson1->mediavideo->file_name); ?>"></div>
    <?php elseif($lesson1->mediavideo->type == 'vimeo'): ?>
    <div id="player" class="js-player" data-plyr-provider="vimeo"
    data-plyr-embed-id="<?php echo e($lesson1->mediavideo->file_name); ?>"></div>
    <?php elseif($lesson1->mediavideo->type == 'upload'): ?>
    <video poster="" id="player" class="js-player" playsinline controls style="    width: 100%;">
    <source src="<?php echo e($lesson1->mediavideo->url); ?>" type="video/mp4"/>
    </video>
    <?php elseif($lesson1->mediavideo->type == 'embed'): ?>
    <?php echo $lesson1->mediavideo->url; ?>

    <?php endif; ?>
    </div>
<?php endif; ?>
                                                </div>



                                            </div>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <!-- /market guide -->

                    <div class="course-review" style="display: none;">
                        <div class="section-title-2 mb20 headline text-left">
                            <h2><?php echo app('translator')->get('labels.frontend.course.course_reviews'); ?></h2>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="ratting-preview">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="avrg-rating ul-li">
                                                <b><?php echo app('translator')->get('labels.frontend.course.average_rating'); ?></b>
                                                <span class="avrg-rate"><?php echo e($course_rating); ?></span>
                                                <ul>
                                                    <?php for($r=1; $r<=$course_rating; $r++): ?>
                                                        <li><i class="fas fa-star"></i></li>
                                                    <?php endfor; ?>
                                                </ul>
                                                <b><?php echo e($total_ratings); ?> <?php echo app('translator')->get('labels.frontend.course.ratings'); ?></b>
                                            </div>
                                        </div>
                                        <div class="col-md-8">
                                            <div class="avrg-rating ul-li">
                                                <span><b><?php echo app('translator')->get('labels.frontend.course.details'); ?></b></span>
                                                <?php for($r=5; $r>=1; $r--): ?>
                                                    <div class="rating-overview">
                                                        <span class="start-item"><?php echo e($r); ?> <?php echo app('translator')->get('labels.frontend.course.stars'); ?></span>
                                                        <span class="start-bar"></span>
                                                        <span class="start-count"><?php echo e($course->reviews()->where('rating','=',$r)->get()->count()); ?></span>
                                                    </div>
                                                <?php endfor; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /review overview -->

                    <div class="couse-comment" style="display: none;">
                        <div class="blog-comment-area ul-li about-teacher-2">
                            <?php if(count($course->reviews) > 0): ?>
                                <ul class="comment-list">
                                    <?php $__currentLoopData = $course->reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="d-block">
                                            <div class="comment-avater">
                                                <img src="<?php echo e($item->user->picture); ?>" alt="">
                                            </div>

                                            <div class="author-name-rate">
                                                <div class="author-name float-left">
                                                    <?php echo app('translator')->get('labels.frontend.course.by'); ?>:
                                                    <span><?php echo e($item->user->full_name); ?></span>
                                                </div>
                                                <div class="comment-ratting float-right ul-li">
                                                    <ul>
                                                        <?php for($i=1; $i<=(int)$item->rating; $i++): ?>
                                                            <li><i class="fas fa-star"></i></li>
                                                        <?php endfor; ?>
                                                    </ul>
                                                    <?php if(auth()->check() && ($item->user_id == auth()->user()->id)): ?>
                                                        <div>
                                                            <a href="<?php echo e(route('courses.review.edit',['id'=>$item->id])); ?>"
                                                               class="mr-2"><?php echo app('translator')->get('labels.general.edit'); ?></a>
                                                            <a href="<?php echo e(route('courses.review.delete',['id'=>$item->id])); ?>"
                                                               class="text-danger"><?php echo app('translator')->get('labels.general.delete'); ?></a>
                                                        </div>

                                                    <?php endif; ?>
                                                </div>
                                                <div class="time-comment float-right"><?php echo e($item->created_at->diffforhumans()); ?></div>
                                            </div>
                                            <div class="author-designation-comment">
                                                <p><?php echo e($item->content); ?></p>
                                            </div>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            <?php else: ?>
                                <h4> <?php echo app('translator')->get('labels.frontend.course.no_reviews_yet'); ?></h4>
                            <?php endif; ?>

                            <?php if($purchased_course): ?>
                                <?php if(isset($review) || ($is_reviewed == false)): ?>
                                    <div class="reply-comment-box">
                                        <div class="review-option">
                                            <div class="section-title-2  headline text-left float-left">
                                                <h2><?php echo app('translator')->get('labels.frontend.course.add_reviews'); ?></h2>
                                            </div>
                                            <div class="review-stars-item float-right mt15">
                                                <span><?php echo app('translator')->get('labels.frontend.course.your_rating'); ?>: </span>
                                                <div class="rating">
                                                    <label>
                                                        <input type="radio" name="stars" value="1"/>
                                                        <span class="icon"><i class="fas fa-star"></i></span>
                                                    </label>
                                                    <label>
                                                        <input type="radio" name="stars" value="2"/>
                                                        <span class="icon"><i class="fas fa-star"></i></span>
                                                        <span class="icon"><i class="fas fa-star"></i></span>
                                                    </label>
                                                    <label>
                                                        <input type="radio" name="stars" value="3"/>
                                                        <span class="icon"><i class="fas fa-star"></i></span>
                                                        <span class="icon"><i class="fas fa-star"></i></span>
                                                        <span class="icon"><i class="fas fa-star"></i></span>
                                                    </label>
                                                    <label>
                                                        <input type="radio" name="stars" value="4"/>
                                                        <span class="icon"><i class="fas fa-star"></i></span>
                                                        <span class="icon"><i class="fas fa-star"></i></span>
                                                        <span class="icon"><i class="fas fa-star"></i></span>
                                                        <span class="icon"><i class="fas fa-star"></i></span>
                                                    </label>
                                                    <label>
                                                        <input type="radio" name="stars" value="5"/>
                                                        <span class="icon"><i class="fas fa-star"></i></span>
                                                        <span class="icon"><i class="fas fa-star"></i></span>
                                                        <span class="icon"><i class="fas fa-star"></i></span>
                                                        <span class="icon"><i class="fas fa-star"></i></span>
                                                        <span class="icon"><i class="fas fa-star"></i></span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="teacher-faq-form">
                                            <?php
                                                if(isset($review)){
                                                    $route = route('courses.review.update',['id'=>$review->id]);
                                                }else{
                                                   $route = route('courses.review',['id'=> $course->id]);
                                                }
                                            ?>

                                            <form method="POST"
                                                  action="<?php echo e($route); ?>"
                                                  data-lead="Residential">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="rating" id="rating">
                                                <label for="review"><?php echo app('translator')->get('labels.frontend.course.message'); ?></label>
                                                <textarea name="review" class="mb-2" id="review" rows="2"
                                                          cols="20"><?php if(isset($review)): ?><?php echo e($review->content); ?> <?php endif; ?></textarea>
                                                <span class="help-block text-danger"><?php echo e($errors->first('review', ':message')); ?></span>
                                                <div class="nws-button text-center  gradient-bg text-uppercase">
                                                    <button type="submit"
                                                            value="Submit"><?php echo app('translator')->get('labels.frontend.course.add_review_now'); ?>
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>


                        </div>
                    </div>

                    <?php if($course->bundles && (count($course->bundles) > 0)): ?>
                        <div class="course-details-category ul-li mt-5">
                            <h3 class="float-none text-dark"><?php echo app('translator')->get('labels.frontend.course.available_in_bundles'); ?></h3>
                        </div>
                        <div class="genius-post-item mb55">
                            <div class="tab-container">
                                <div id="tab1" class="tab-content-1 pt35">
                                    <div class="best-course-area best-course-v2">
                                        <div class="row">
                                            <?php $__currentLoopData = $course->bundles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bundle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                <div class="col-md-4">
                                                    <div class="best-course-pic-text relative-position">
                                                        <div class="best-course-pic relative-position"
                                                             <?php if($bundle->course_image != ""): ?> style="background-image: url('<?php echo e(asset('storage/uploads/'.$course->course_image)); ?>')" <?php endif; ?>>

                                                            <?php if($bundle->trending == 1): ?>
                                                                <div class="trend-badge-2 text-center text-uppercase">
                                                                    <i class="fas fa-bolt"></i>
                                                                    <span><?php echo app('translator')->get('labels.frontend.badges.trending'); ?></span>
                                                                </div>
                                                            <?php endif; ?>
                                                            <?php if($bundle->free == 1): ?>
                                                                <div class="trend-badge-3 text-center text-uppercase">
                                                                    <i class="fas fa-bolt"></i>
                                                                    <span><?php echo app('translator')->get('labels.backend.courses.fields.free'); ?></span>
                                                                </div>
                                                            <?php endif; ?>

                                                            <div class="course-rate ul-li">
                                                                <ul>
                                                                    <?php for($i=1; $i<=(int)$bundle->rating; $i++): ?>
                                                                        <li><i class="fas fa-star"></i></li>
                                                                    <?php endfor; ?>
                                                                </ul>
                                                            </div>
                                                            <div class="course-details-btn">
                                                                <a href="<?php echo e(route('bundles.show', [$bundle->slug])); ?>"><?php echo app('translator')->get('labels.frontend.course.bundle_detail'); ?>
                                                                    <i class="fas fa-arrow-right"></i></a>
                                                            </div>
                                                            <div class="blakish-overlay"></div>
                                                        </div>
                                                        <div class="best-course-text">
                                                            <div class="course-title mb20 headline relative-position">
                                                                <h3>
                                                                    <a href="<?php echo e(route('bundles.show', [$bundle->slug])); ?>"><?php echo e($bundle->title); ?></a>
                                                                </h3>
                                                            </div>
                                                            <div class="course-meta">
                                                            <span class="course-category"><a
                                                                        href="<?php echo e(route('courses.category',['category'=>$bundle->category->slug])); ?>"><?php echo e($bundle->category->name); ?></a></span>
                                                                <span class="course-author"><a href="#"><?php echo e($bundle->students()->count()); ?>

                                                                        <?php echo app('translator')->get('labels.frontend.course.students'); ?></a></span>
                                                                <span class="course-author mr-0"><?php echo e($bundle->courses()->count()); ?>

                                                                    <?php if($bundle->courses()->count() > 1 ): ?>
                                                                        <?php echo app('translator')->get('labels.frontend.course.courses'); ?>
                                                                    <?php else: ?>
                                                                        <?php echo app('translator')->get('labels.frontend.course.course'); ?>
                                                                    <?php endif; ?>
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <!-- /course -->
                                        </div>
                                    </div>
                                </div><!-- /tab-1 -->
                            </div>
                        </div>
                    <?php endif; ?>
                </div>

                <div class="col-md-3">
                    <div class="side-bar">
                        <div class="course-side-bar-widget">

                            <?php


                                $courseExpire = courseOrBundleExpire($course->id,'');
                                //dd($courseExpire);
                            ?>
                            <?php if($courseExpire==false && $subscribe_status!=1): ?>


                                <?php if(auth()->check() && (auth()->user()->hasRole('student'))): ?>
                                    <?php

                                        //dd($subscribe_status);
                                        if( $subscribe_status == 3) {
                                            ?>

                                                    <button class="genius-btn btn-block text-white  gradient-bg text-center bold-font"
                                                            href="#" data-toggle="modal" data-target="#myModal"> Request for Subscription <i
                                                                class="fas fa-caret-right"></i></button>

                                            <?php
                                        } elseif ($subscribe_status == 0) {
                                            ?>
                                             <a class="genius-btn btn-block text-white  gradient-bg text-center "
                                             href="#">Awating for Approval</a>
                                            <?php
                                        }
                                    ?>


                                <?php else: ?>
                                    <h6 class="alert alert-danger"> <?php echo app('translator')->get('labels.frontend.course.buy_note'); ?></h6>
                                <?php endif; ?>
                                <?php echo $__env->make('frontend.layouts.partials.wishlist',['course' => $course->id, 'price' => $course->price], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php else: ?>
                                <?php 
                                    $first_lesson_slug = null;
                                    if(isset($course->publishedLessons[0])) {
                                        $first_lesson_slug = $course->publishedLessons[0]->slug;
                                    }
                                ?>
                                <?php if(($continue_course || $subscribe_status == 1) && $course && count($lessons)): ?>
                                    <a href="<?php echo e(route('lessons.show',['course_id' => $course->id,'slug'=>$first_lesson_slug])); ?>"
                                       class="genius-btn btn-block text-white  gradient-bg text-center text-uppercase  bold-font">

                                        <?php echo app('translator')->get('labels.frontend.course.continue_course'); ?>

                                        <i class="fa fa-arow-right"></i> </a>
                                <?php else: ?>
                                        <span class="genius-btn btn-block text-white  gradient-bg text-center text-uppercase  bold-font">No lessons, contact admin</span>
                                <?php endif; ?>



                            <?php endif; ?>

                        </div>
                        <div class="enrolled-student">
                            <div class="comment-ratting float-left ul-li">
                                <ul>
                                    <?php for($i=1; $i<=(int)$course->rating; $i++): ?>
                                        <li><i class="fas fa-star"></i></li>
                                    <?php endfor; ?>
                                </ul>
                            </div>
                            <div class="student-number bold-font">
                                
                            </div>
                        </div>
                        <div class="couse-feature ul-li-block">
                            <ul>
                                <li ><em> <?php echo app('translator')->get('labels.frontend.course.chapters'); ?></em>
                                    <span style="display: none;">  <?php echo e($course->chapterCount()); ?> </span>
                                    <span >  <?php echo e($lessonCount); ?> </span></li>
                                
                                <li class="d-inline-block w-100"><em><?php echo app('translator')->get('labels.frontend.course.category'); ?></em><span><a
                                                href="<?php echo e(route('courses.category',['category'=>$course->category->slug])); ?>"
                                                target="_blank"><?php echo e($course->category->name); ?></a> </span></li>
                                <li> <em><?php echo app('translator')->get('labels.frontend.course.author'); ?> </em> <span>

                                        <?php $__currentLoopData = $course->teachers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$teacher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                            <?php if($teacher->hasRole('teacher')): ?>
                                            <?php $key++ ?>
                                            <a href="<?php echo e(route('teachers.show',['id'=>$teacher->id])); ?>" target="_blank">
                                                <?php echo e($teacher->full_name); ?><?php if($key < count($course->teachers )): ?>, <?php endif; ?>
                                            </a>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                       </span>
                                </li>
                            </ul>

                        </div>

                        <?php if($recent_news->count() > 0): ?>
                            <div class="side-bar-widget">
                                <h2 class="widget-title text-capitalize"><?php echo app('translator')->get('labels.frontend.course.recent_news'); ?></h2>
                                <div class="latest-news-posts">
                                    <?php $__currentLoopData = $recent_news; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="latest-news-area">
                                            <?php if($item->image != ""): ?>
                                                <div class="latest-news-thumbnile relative-position"
                                                     style="background-image: url(<?php echo e(asset('storage/uploads/'.$item->image)); ?>)">
                                                    <div class="blakish-overlay"></div>
                                                </div>
                                            <?php endif; ?>


                                            <div class="date-meta">
                                                <i class="fas fa-calendar-alt"></i> <?php echo e($item->created_at->format('d M Y')); ?>

                                            </div>
                                            <h3 class="latest-title bold-font"><a
                                                        href="<?php echo e(route('blogs.index',['slug'=>$item->slug.'-'.$item->id])); ?>"><?php echo e($item->title); ?></a>
                                            </h3>
                                        </div>
                                        <!-- /post -->
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                    <div class="view-all-btn bold-font">
                                        <a href="<?php echo e(route('blogs.index')); ?>"><?php echo app('translator')->get('labels.frontend.course.view_all_news'); ?>
                                            <i class="fas fa-chevron-circle-right"></i></a>
                                    </div>
                                </div>
                            </div>

                        <?php endif; ?>

                        <?php if($global_featured_course != ""): ?>
                            <div class="side-bar-widget">
                                <h2 class="widget-title text-capitalize"><?php echo app('translator')->get('labels.frontend.course.featured_course'); ?></h2>
                                <div class="featured-course">
                                    <div class="best-course-pic-text relative-position pt-0">
                                        <div class="best-course-pic relative-position "
                                             <?php if($global_featured_course->course_image != ""): ?> style="background-image: url(<?php echo e(asset('storage/uploads/'.$global_featured_course->course_image)); ?>)" <?php endif; ?>>

                                            <?php if($global_featured_course->trending == 1): ?>
                                                <div class="trend-badge-2 text-center text-uppercase">
                                                    <i class="fas fa-bolt"></i>
                                                    <span><?php echo app('translator')->get('labels.frontend.badges.trending'); ?></span>
                                                </div>
                                            <?php endif; ?>
                                            <?php if($global_featured_course->free == 1): ?>
                                                <div class="trend-badge-3 text-center text-uppercase">
                                                    <i class="fas fa-bolt"></i>
                                                    <span><?php echo app('translator')->get('labels.backend.courses.fields.free'); ?></span>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="best-course-text" style="left: 0;right: 0;">
                                            <div class="course-title mb20 headline relative-position">
                                                <h3>
                                                    <a href="<?php echo e(route('courses.show', [$global_featured_course->slug])); ?>"><?php echo e($global_featured_course->title); ?></a>
                                                </h3>
                                            </div>
                                            <div class="course-meta">
                                                <span class="course-category"><a
                                                            href="<?php echo e(route('courses.category',['category'=>$global_featured_course->category->slug])); ?>"><?php echo e($global_featured_course->category->name); ?></a></span>
                                                <span class="course-author"><?php echo e($global_featured_course->students()->count()); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">

                <!-- Modal Header -->
                <div class="modal-header">


                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>

                </div>

                <!-- Modal body -->
                <div class="modal-body">
                    <div class="tab-content">
                    <form action="<?php echo e(route('register.save.register.course')); ?>" method="post" autocomplete="off">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="course_id" value="<?php echo e($course->id); ?>" />
                        <input type="hidden" name="amount" value="<?php echo e(($course->free == 1) ? 0 : $course->price); ?>"/>
                        <input type="hidden" name="slug" value="<?php echo e($course->slug); ?>"/>
                        <div class="form-group">
                            <label for="exampleInputEmail1">Enter Your Email address</label>
                            <input type="email"  class="form-control" name="email" id="email" placeholder="Enter email" value="" required>
                        </div>
                        <div class="row">
                            <div class="col-sm-6 col-12">
                            <div class="form-group">
                            <label for="exampleInputEmail1">First Name</label>
                            <input type="text"  class="form-control" name="first_name" id="first_name" placeholder="Enter first name" value="" required>
                        </div>
                            </div>
                            <div class="col-sm-6 col-12">
                            <div class="form-group">
                            <label for="exampleInputEmail1">Last name</label>
                            <input type="text"  class="form-control" name="last_name" id="last_name" placeholder="Enter last name" value="" required>
                        </div>
                            </div>
                            <div class="col-sm-6 col-12">
                            <div class="form-group">
                            <label for="exampleInputEmail1">Phone</label>
                            <input type="text"  class="form-control" name="phone" id="phone" placeholder="Enter phone" value="" required>

                        </div>
                            </div>
                            <div class="col-sm-6 col-12">
                            <div class="form-group">
                            <label for="exampleInputEmail1">ID number</label>
                            <input type="text"  class="form-control" name="id_no" id="id_no" placeholder="Enter ID No" value="" required>
                        </div>
                            </div>

                            <div class="col-sm-6 col-12"><div class="form-group">
                            <label for="exampleInputEmail1">Classification number</label>
                            <input type="text"  class="form-control" name="classification_no" id="classification_no" placeholder="Classification number" value="">
                        </div></div>
                            <div class="col-sm-6 col-12">
                            <div class="form-group">
                            <label for="exampleInputEmail1">Specialization</label>
                            <input type="text"  class="form-control" name="specialization" id="specialization" placeholder="specialization" value="" required>

                        </div>
                            </div>

                        </div>

                        <div class="form-group">
                            <label for="exampleInputEmail1">Nationality</label>
                            <select name="nationality" class="form-control" required>
                                <option>Select Country</option>
                                <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($country->id); ?>"><?php echo e($country->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">Gender</label>
                            <select name="gender" class="form-control" required>
                                <option value="male">Male</option>
                                <option value="female">Female</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">Password</label>
                            <input type="password"  class="form-control" name="password" id="password" placeholder="Enter password" required>

                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">Confirm Password</label>
                            <input type="password"  class="form-control" name="confirm_password" id="confirm_password" placeholder="Enter Confirm Password" required>

                        </div>

                        <button type="submit" class="btn btn-primary">Register on course</button>
                    </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
    </section>
    <!-- End of course details section
        ============================================= -->

<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>
    <script src="https://cdn.plyr.io/3.5.3/plyr.polyfilled.js"></script>


    <script>
        const player = new Plyr('#player');
        $( document ).ready(function() {
    $('input').attr('autocomplete','off');
});
        $(document).on('change', 'input[name="stars"]', function () {
            $('#rating').val($(this).val());
        })
                <?php if(isset($review)): ?>
        var rating = "<?php echo e($review->rating); ?>";
        $('input[value="' + rating + '"]').prop("checked", true);
        $('#rating').val(rating);
        <?php endif; ?>
    </script>








    
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.layouts.app'.config('theme_layout'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/tadreeblms/resources/views/frontend/courses/course.blade.php ENDPATH**/ ?>