<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h5><?php echo e(isset($role) ? 'Edit Role' : 'Add Role'); ?></h5>
        <a href="<?php echo e(route('admin.roles.index')); ?>" class="btn btn-secondary float-end">Back</a>
    </div>

    <div class="card-body">
        <form action="<?php echo e(isset($role) ? route('admin.roles.update', $role->id) : route('admin.roles.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php if(isset($role)): ?>
                <?php echo method_field('PUT'); ?>
            <?php endif; ?>

            <div class="mb-3">
                <label for="name" class="form-label">Role Name</label>
                <input type="text" name="name" id="name" class="form-control" value="<?php echo e($role->name ?? old('name')); ?>" required>
            </div>

            <div class="mb-3">
                <h6>Permissions</h6>

                <div class="form-check mb-2">
    <input type="checkbox" class="form-check-input" id="select_all_permissions">
    <label class="form-check-label fw-bold" for="select_all_permissions">
        Select / Unselect All Permissions
    </label>
</div>


                <div class="permission-blocks row">
                <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module => $modulePermissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="mb-2 border p-2 rounded">
                        <strong><?php echo e(ucfirst($module)); ?></strong>
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input select-all" data-module="<?php echo e($module); ?>" id="select_all_<?php echo e($module); ?>">
                            <label class="form-check-label" for="select_all_<?php echo e($module); ?>">Select All</label>
                        </div>

                        <?php $__currentLoopData = $modulePermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <?php
                                $default_permission_checked = false;
                            ?>

                            <?php if($module == 'backend'): ?>
                                <?php
                                    $default_permission_checked = true;
                                ?>
                            <?php endif; ?>
                            <div class="form-check ms-3">
                                <input type="checkbox"
                                    name="permissions[]"
                                    class="form-check-input permission-<?php echo e($module); ?>"
                                    value="<?php echo e($permission->id); ?>"
                                    id="perm_<?php echo e($permission->id); ?>"
                                    <?php if($default_permission_checked): ?> checked <?php endif; ?>
                                   >
                                <label class="form-check-label" for="perm_<?php echo e($permission->id); ?>">
                                    <?php echo e($permission->name); ?>

                                </label>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <button type="submit" class="btn btn-success"><?php echo e(isset($role) ? 'Update Role' : 'Create Role'); ?></button>
        </form>
    </div>
</div>


<?php $__env->startPush('after-scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {

    const globalCheckbox = document.getElementById('select_all_permissions');
    const moduleCheckboxes = document.querySelectorAll('.select-all');
    const permissionCheckboxes = document.querySelectorAll('input[name="permissions[]"]');

    // 🔹 GLOBAL SELECT ALL
    globalCheckbox.addEventListener('change', function () {
        const checked = this.checked;

        moduleCheckboxes.forEach(m => m.checked = checked);
        permissionCheckboxes.forEach(p => p.checked = checked);
    });

    // 🔹 MODULE SELECT ALL
    moduleCheckboxes.forEach(function (moduleCheckbox) {
        moduleCheckbox.addEventListener('change', function () {
            const module = this.dataset.module;
            const permissions = document.querySelectorAll('.permission-' + module);

            permissions.forEach(p => p.checked = this.checked);
            updateGlobalState();
        });
    });

    // 🔹 INDIVIDUAL PERMISSION CHANGE
    permissionCheckboxes.forEach(function (permission) {
        permission.addEventListener('change', function () {
            updateModuleState();
            updateGlobalState();
        });
    });

    // 🔹 UPDATE MODULE STATE
    function updateModuleState() {
        moduleCheckboxes.forEach(moduleCheckbox => {
            const module = moduleCheckbox.dataset.module;
            const permissions = document.querySelectorAll('.permission-' + module);

            moduleCheckbox.checked = [...permissions].every(p => p.checked);
        });
    }

    // 🔹 UPDATE GLOBAL STATE (checked / indeterminate)
    function updateGlobalState() {
        const total = permissionCheckboxes.length;
        const checked = document.querySelectorAll('input[name="permissions[]"]:checked').length;

        globalCheckbox.checked = total === checked;
        globalCheckbox.indeterminate = checked > 0 && checked < total;
    }

});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/tadreeblms/resources/views/backend/roles/create.blade.php ENDPATH**/ ?>