<?php $__env->startSection('title', __('labels.backend.general_settings.title') . ' | ' . app_name()); ?>

<?php $__env->startPush('after-styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('plugins/bootstrap-iconpicker/css/bootstrap-iconpicker.min.css')); ?>" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('assets/css/colors/switch.css')); ?>">
    <style>
        .color-list li {
            float: left;
            width: 8%;
        }

        .error{
            margin-top: 5px;
            color: green;
            font-weight: bold;
        }

        @media screen and (max-width: 768px) {
            .color-list li {
                width: 20%;
                padding-bottom: 20px;
            }

            .color-list li:first-child {
                padding-bottom: 0px;
            }
        }

        .options {
            line-height: 35px;
        }

        .color-list li a {
            font-size: 20px;
        }

        .color-list li a.active {
            border: 4px solid grey;
        }

        .color-default {
            font-size: 18px !important;
            background: #101010;
            border-radius: 100%;
        }

        .form-control-label {
            line-height: 35px;
        }

        .switch.switch-3d {
            margin-bottom: 0px;
            vertical-align: middle;

        }

        .color-default i {
            background-clip: text;
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .preview {
            background-color: #dcd8d8;
            background-image: url(https://www.transparenttextures.com/patterns/carbon-fibre-v2.png);
        }

        #logos img {
            height: auto;
            width: 100%;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    

    <div class="card">
        <div class="card-body">
            
            <div class="row">
                <div class="col-sm-12">
                    <ul class="nav main-nav-tabs nav-tabs">
                        <li class="nav-item"><a data-toggle="tab" class="nav-link active " href="#general">
                                <?php echo e(__('LDAP Setting')); ?>

                            </a>
                        </li>
                        
                       
                    </ul>
                    <h4 class="card-title mb-0">
                        
                    </h4>
                </div><!--col-->
            </div><!--row-->

            <div class="tab-content">
                <!---General Tab--->
                <div id="general" class="tab-pane container active">
                    <div class="row mt-4 mb-4">
                        <div class="col">

                            <form method="POST"
                                action="<?php echo e(route('admin.ldap-settings')); ?>"
                                id="landing-general-settings-form"
                                class="form-horizontal">
                                <?php echo csrf_field(); ?>

                                <div class="form-group row">
                                    <label class="col-md-4">Enable LDAP</label>
                                    <div class="col-md-8">
                                        <label class="switch switch-lg switch-3d switch-primary">
                                            <input type="checkbox"
                                                class="switch-input"
                                                name="ldap_toggle"
                                                value="1"
                                                <?php echo e($ldap_toggle == 1 ? 'checked' : ''); ?>>
                                            <span class="switch-label"></span>
                                            <span class="switch-handle"></span>
                                        </label>
                                    </div>
                                </div>

                                <hr>

                                <div class="form-group row">
                                    <label class="col-md-4">LDAP Host</label>
                                    <div class="col-md-8">
                                        <input type="text" name="ldap_host" class="form-control"
                                            value="<?php echo e($ldap_host ?? '127.0.0.1'); ?>">
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-md-4">LDAP Port</label>
                                    <div class="col-md-8">
                                        <input type="text" name="ldap_port" class="form-control"
                                            value="<?php echo e($ldap_port ?? '389'); ?>">
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-md-4">Base DN</label>
                                    <div class="col-md-8">
                                        <input type="text" name="ldap_base_dn" class="form-control"
                                            value="<?php echo e($ldap_base_dn ?? 'dc=mycompany,dc=local'); ?>">
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-md-4">Admin Username (Bind DN)</label>
                                    <div class="col-md-8">
                                        <input type="text" name="ldap_username" class="form-control"
                                            value="<?php echo e($ldap_username ?? 'cn=admin,dc=mycompany,dc=local'); ?>">
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-md-4">Admin Password</label>
                                    <div class="col-md-8">
                                        <input type="password" name="ldap_password" class="form-control"
                                            value="<?php echo e($ldap_password ?? ''); ?>">
                                    </div>
                                </div>

                                <button type="button" id="saveLdapBtn" class="btn btn-primary mt-3">
                                    Save Configuration
                                </button>

                                <div id="ldapStatusMsg" class=" error"></div>

                            </form>
                            <br>
                            <hr>
                            <div class="mt-20">
                            <h3>Test LDAP Connection</h3>
                            <form>
                                <button type="button" id="test_ldap_connection" class="btn btn-primary mt-3">
                                    Test LDAP Connection
                                </button>
                                <div id="ldapStatus" class="error"></div>
                            </form>
                            </div>

                        </div>
                    </div>

                </div>

            </div>
        </div>
    </div>
    
<?php $__env->stopSection(); ?>


<?php $__env->startPush('after-scripts'); ?>
    <script src="<?php echo e(asset('plugins/bootstrap-iconpicker/js/bootstrap-iconpicker.bundle.min.js')); ?>"></script>
    <script>
    $('#saveLdapBtn').click(function() {

        let formData = {
            _token: "<?php echo e(csrf_token()); ?>",
            ldap_toggle: $('input[name="ldap_toggle"]').is(':checked') ? 1 : 0,
            ldap_host: $('input[name="ldap_host"]').val(),
            ldap_port: $('input[name="ldap_port"]').val(),
            ldap_base_dn: $('input[name="ldap_base_dn"]').val(),
            ldap_username: $('input[name="ldap_username"]').val(),
            ldap_password: $('input[name="ldap_password"]').val(),
        };

        

        // STEP 1: Save to .env
        $.post("<?php echo e(route('admin.ldap.save.env')); ?>", formData, function(res) {

            
            if (res.status === 'success') {
                $('#ldapStatusMsg').html('<span class="text-success">' + res.message + '</span>');
            } else {
                $('#ldapStatusMsg').html('<span class="text-danger">' + res.message + '</span>');
            }

        });
    });

    $('#test_ldap_connection').click(function() {

        let formData = {
            _token: "<?php echo e(csrf_token()); ?>",
            ldap_toggle: $('input[name="ldap_toggle"]').is(':checked') ? 1 : 0,
            ldap_host: $('input[name="ldap_host"]').val(),
            ldap_port: $('input[name="ldap_port"]').val(),
            ldap_base_dn: $('input[name="ldap_base_dn"]').val(),
            ldap_username: $('input[name="ldap_username"]').val(),
            ldap_password: $('input[name="ldap_password"]').val(),
        };

        // STEP 1: Save to .env
        $.post("<?php echo e(route('admin.ldap.test')); ?>", formData, function(res) {

            if (res.status === 'connected') {
                $('#ldapStatus').html('<span class="text-success">' + res.message + '</span>');
            } else {
                $('#ldapStatus').html('<span class="text-danger">' + res.message + '</span>');
            }

        });
    });

    




        $(document).ready(function() {



            <?php if(request()->has('tab')): ?>
                var tab = "<?php echo e(request('tab')); ?>";
                $('.nav-tabs a[href="#' + tab + '"]').tab('show');
            <?php endif; ?>

            //========= Initialisation for Iconpicker ===========//
            $('#icon').iconpicker({
                cols: 10,
                icon: 'fab fa-facebook-f',
                iconset: 'fontawesome5',
                labelHeader: '{0} of {1} pages',
                labelFooter: '{0} - {1} of {2} icons',
                placement: 'bottom', // Only in button tag
                rows: 5,
                search: true,
                searchText: 'Search',
                selectedClass: 'btn-success',
                unselectedClass: ''
            });


            //========== Preset theme layout ==============//
            <?php if(config('theme_layout') != ''): ?>
                $('#theme_layout').find('option').removeAttr('selected')
                $('#theme_layout').find('option[value="<?php echo e(config('theme_layout')); ?>"]').attr('selected',
                    'selected');
            <?php endif; ?>


            //============ Preset font color ===============//
            <?php if(config('font_color') != ''): ?>
                $('.color-list').find('li a').removeClass('active');
                $('.color-list').find('li a[data-color="<?php echo e(config('font_color')); ?>"]').addClass('active');
                $('#font_color').val("<?php echo e(config('font_color')); ?>");
            <?php endif; ?>


            //========= Preset Layout type =================//
            <?php if(config('layout_type') != ''): ?>
                $('#layout_type').find('option').removeAttr('selected')
                $('#layout_type').find('option[value="<?php echo e(config('layout_type')); ?>"]').attr('selected',
                    'selected');
            <?php endif; ?>


            //=========== Preset Counter data =============//
            <?php if(config('counter') != ''): ?>
                <?php if((int) config('counter') == 1): ?>
                    $('.counter-container').removeClass('d-none')
                    $('#total_students').val("<?php echo e(config('total_students')); ?>");
                    $('#total_teachers').val("<?php echo e(config('total_teachers')); ?>");
                    $('#total_courses').val("<?php echo e(config('total_courses')); ?>");
                <?php else: ?>
                    $('#counter-container').empty();
                <?php endif; ?>

                <?php if(config('counter') != ''): ?>
                    $('.counter-container').removeClass('d-none');
                <?php endif; ?>

                $('#counter').find('option').removeAttr('selected')
                $('#counter').find('option[value="<?php echo e(config('counter')); ?>"]').attr('selected', 'selected');
            <?php endif; ?>


            //======== Preset PaymentMode for Paypal =======>
            <?php if(config('paypal.settings.mode') != ''): ?>
                $('#paypal_settings_mode').find('option').removeAttr('selected')
                $('#paypal_settings_mode').find('option[value="<?php echo e(config('paypal.settings.mode')); ?>"]').attr(
                    'selected', 'selected');
            <?php endif; ?>

            //======== Preset PaymentMode for Instamojo =======>
            <?php if(config('services.instamojo.mode') != ''): ?>
                $('#instamojo_settings_mode').find('option').removeAttr('selected')
                $('#instamojo_settings_mode').find('option[value="<?php echo e(config('services.instamojo.mode')); ?>"]')
                    .attr('selected', 'selected');
            <?php endif; ?>

            //======== Preset PaymentMode for Cashfree =======>
            <?php if(config('services.cashfree.mode') != ''): ?>
                $('#cashfree_settings_mode').find('option').removeAttr('selected')
                $('#cashfree_settings_mode').find('option[value="<?php echo e(config('services.cashfree.mode')); ?>"]').attr(
                    'selected', 'selected');
            <?php endif; ?>

            //======== Preset PaymentMode for PayUMoney =======>
            <?php if(config('services.payu.mode') != ''): ?>
                $('#cashfree_settings_mode').find('option').removeAttr('selected')
                $('#cashfree_settings_mode').find('option[value="<?php echo e(config('services.payu.mode')); ?>"]').attr(
                    'selected', 'selected');
            <?php endif; ?>

            //======== Preset PaymentMode for Flutter =======>
            <?php if(config('rave.env') != ''): ?>
                $('#rave_env').find('option').removeAttr('selected')
                $('#rave_env').find('option[value="<?php echo e(config('rave.env')); ?>"]').attr('selected', 'selected');
            <?php endif; ?>


            //============= Font Color selection =================//
            $(document).on('click', '.color-list li', function() {
                $(this).siblings('li').find('a').removeClass('active')
                $(this).find('a').addClass('active');
                $('#font_color').val($(this).find('a').data('color'));
            });


            

            






         

            <?php if(request()->has('tab')): ?>
                var tab = "<?php echo e(request('tab')); ?>";
                $('.nav-tabs a[href="#' + tab + '"]').tab('show');
            <?php endif; ?>

        });

        $(document).on('click', '.switch-input', function(e) {
            //              e.preventDefault();
            var content = $(this).parents('.checkbox').siblings('.switch-content');
            if (content.hasClass('d-none')) {
                $(this).attr('checked', 'checked');
                content.find('input').attr('required', true);
                content.removeClass('d-none');
            } else {
                content.addClass('d-none');
                content.find('input').attr('required', false);
            }
        })


        
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/stag/tadreeblms/resources/views/backend/settings/ldap_setting.blade.php ENDPATH**/ ?>