<?php $__env->startSection('title', __('Assignments').' | '.app_name()); ?>

<?php $__env->startPush('after-styles'); ?>
<style>
.step_assign{
  font-size: 17px;
  font-weight: 600;
  padding-left: 12px;
  border-bottom: 1px solid #e7e7e7;
  padding-bottom: 11px;
  margin-bottom: 25px;
  display: block;
}

/* .select2-container--default .select2-selection--single .select2-selection__arrow {
    background-image: url("data:image/svg+xml,%3Csvg fill='black' height='24' viewBox='0 0 24 24' width='24' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M7 10l5 5 5-5z'/%3E%3C/svg%3E");
    background-repeat: no-repeat;
    background-position: center;
    background-size: 16px;
    width: 30px;
    height: 100%;
    right: 6px;
    top: 0;
} */


/* Add FontAwesome arrow */
.select2-container--default .select2-selection--single .select2-selection__arrow::after {
    content: '\f078'; /* Unicode for caret-down */
    font-family: "Font Awesome 5 Free";
    font-weight: 900;
    position: absolute;
    right: 10px;
    top: 50%;
    transform: translateY(-26%);
    pointer-events: none;
    color: #333;
    font-size: 14px;
}

.select2-container--default .select2-selection--single .select2-selection__arrow b {
    display: none !important;
}

/* Basic style */
.select2-container--default .select2-selection--single {
    border: 1px solid #ced4da;
    border-radius: 4px;
    height: 35px;
    padding: 2px 5px;
    background-color: #fff;
    transition: border 0.3s ease;
}

/* Focus style */
.select2-container--default.select2-container--focus .select2-selection--single {
    border-color: #007bff !important;
    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
}



/* Add FontAwesome arrow using ::after on the wrapper */


</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<form action="<?php echo e(route('admin.assessment_accounts.course-assignment-invitation')); ?>" method="POST" enctype="multipart/form-data" class="form-horizontal">
    <?php echo csrf_field(); ?>
   
    <div class="pb-3 d-flex justify-content-between align-items-center">
        <h4 ><?php echo app('translator')->get('Create Invitation Assignment'); ?></h4>
        <div>
            <?php if($user_id != NULL): ?>
            <a href="<?php echo e(route('admin.assessment_accounts.account_assignments', $user_id)); ?>" class="btn add-btn"><?php echo app('translator')->get('View Assignments'); ?></a>
            <?php else: ?>
            <a href="<?php echo e(route('admin.assessment_accounts.assignments')); ?>" class="btn add-btn"><?php echo app('translator')->get('View Assignments'); ?></a>
            <?php endif; ?>
        </div>
    </div>
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-12">
                <?php if($user_id != NULL): ?>
                <input type="hidden" name="user_id" value="<?php echo e($user_id); ?>">
                <input type="hidden" name="user_type" value="2">
                <?php else: ?>
                <input type="hidden" name="user_type" value="1">
                <?php endif; ?>
                <input type="hidden" name="reschedule" value="<?php echo e($reschedule); ?>" />
                <div class="">
                <label style="font-size: 17px;font-weight: 600;padding-left: 12px;border-bottom: 1px solid #e7e7e7;padding-bottom: 11px;margin-bottom: 25px;display: block;">Make a New Assignment (Step-1)</label>
                </div>

                

                

                <div class="form-group row">
                    <div class="col-md-12">
                        <div class="custom-select-wrapper ">
                            <select class="form-control custom-select-box" name="course_type" id="course_type">
                                <option value="Offline" <?php echo e(old('course_type') == 'Offline' ? 'selected' : ''); ?>>Live-Online</option>
                                <option value="Live-Classroom" <?php echo e(old('course_type') == 'Live-Classroom' ? 'selected' : ''); ?>>Live-Classroom</option>
                            </select>
                            <span class="custom-select-icon" style="right: 10px;">
                            <i class="fa fa-chevron-down"></i>
                        </span>
                        </div>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-md-12 form-control-label" for="course_id">Course</label>
                    <div class="col-md-12">
                        <select class="form-control custom-select-box select2" name="course_id">
                            <option value="" disabled <?php echo e(old('course_id') ? '' : 'selected'); ?>>Select One Course</option>
                            <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($value->id); ?>" <?php echo e(old('course_id') == $value->id ? 'selected' : ''); ?>>
                                    <?php echo e($value->title); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-md-12 form-control-label" for="title">Date</label>
                    <div class="col-md-12">
                        <input class="form-control" value="<?php echo e(old('due_date')); ?>" type="datetime-local" name="due_date" id="due_date" required="" autofocus="">
                    </div>
                </div>

                <div class="form-group row" id="show-meetlink">
                    <label class="col-md-12 form-control-label" for="title">Meeting Link</label>
                    <div class="col-md-12">
                        <input class="form-control" value="<?php echo e(old('meeting_link')); ?>" type="text" name="meeting_link" id="meeting_link" autofocus="">
                    </div>
                </div>

                <div class="form-group row" id="show-location" style="display: none;">
                    <label class="col-md-12 form-control-label" for="title">Classroom Location</label>
                    <div class="col-md-12">
                        <input class="form-control" value="<?php echo e(old('classroom_location')); ?>" type="text" name="classroom_location" id="classroom_location" autofocus="">
                    </div>
                </div>

                <div class="form-group row" id="show-meetlink-datetime">
                    <label class="col-md-12 form-control-label" for="title">Meeting End DateTime</label>
                    <div class="col-md-12">
                        <input class="form-control" type="datetime-local" name="meeting_end_datetime" value="<?php echo e(old('meeting_end_datetime')); ?>"  id="meeting_end_datetime" autofocus="">
                    </div>
                </div>

                

                

                

                

                <!-- or

                <br>

                <div class="form-group row">
                    <label class="col-md-12 form-control-label" for="test_id">Category</label>
                    <div class="col-md-12">
                        <select class="form-control" name="category_id">
                            <option value="">Select One Category</option>
                            <?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($value->id); ?>"><?php echo e($value->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div> -->

                <div class="">
                <label style=" font-size: 17px;font-weight: 600;padding-left: 12px;border-bottom: 1px solid #e7e7e7;padding-bottom: 11px;margin-bottom: 25px;display: block;">Make a New Assignment (Step-2)</label>
                </div>

                <div class="">
                <label class="">Assign to...</label>
                </div>


                <div class="form-group row">
                <label class="col-md-12 form-control-label" for="test_id">Users</label>
                    <div class="col-md-12 custom-select-wrapper">
                        <select name="teachers[]" class="form-control custom-select-box select2 js-example-placeholder-multiple" multiple>
                            <?php $__currentLoopData = $teachers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($value); ?>" <?php echo e(in_array($value, old('teachers', [])) ? 'selected' : ''); ?>>
                                    <?php echo e($label); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <span class="custom-select-icon" style="right:23px">
        <i class="fa fa-chevron-down"></i>
    </span>
                        
                    </div>
                </div>


         OR
         <br>
         <div class="row">

             <div class="col-md-12">
               <label class=" form-control-label" for="first_name">Select Department</label>
   
               <div class=" custom-select-wrapper">
                   <select name="department_id" class="form-control custom-select-box select2">
                       <option value=""> Select One </option>
                       <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                       <option value="<?php echo e($row->id); ?>"> <?php echo e($row->title); ?> </option>
                       <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                   </select>
                   <span class="custom-select-icon" style="right: 10px;">
        <i class="fa fa-chevron-down"></i>
    </span>
               </div>
               <!--col-->
           </div>
         </div>
        <br>

                <div class="form-group row">
                    <label class="col-md-12 form-control-label" for="verify_code">Add Custome message</label>
                    <div class="col-md-12">
                        <input class="form-control" type="text" name="message" id="message">
                    </div>
                </div>

                <div class="form-group row">
                    <div class="col-12 col-md-12 d-flex justify-content-between mt-3">
                        

                            <div class="mr-4">
    
                                <?php echo e(form_cancel(route('admin.assessment_accounts.assignments', $user_id), __('buttons.general.cancel'))); ?>

                            </div>
                            <div class="">
    
                                <?php echo e(form_submit(__('buttons.general.crud.create'))); ?>

                            </div>
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</form>
<?php $__env->stopSection(); ?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function () {

        
        $('#course_type').change(function () {
            var course_type = $(this).val();

             $.ajax({
                type: 'POST',
                url: '<?php echo e(route("admin.get.courses.by_course_type")); ?>',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    'course_type':$(this).val()
                },
                datatype: "json",
                success: function (res) {
                    //console.log(res.courses)
                    let $select = $('select[name="course_id"]');
                    $select.empty();
                    $select.append('<option value="" disabled selected>Select One Course</option>');
                    $.each(res.courses, function (index, course) {
                        $select.append(`<option value="${course.id}">${course.title}</option>`);
                    });
                    $select.trigger('change');
                }
            })

            if(course_type == 'Offline') {
                
                 $('#show-location').hide();
                $('#show-meetlink').show();
                //$('#show-meetlink-datetime').show();
            } else {
               $('#show-location').show();
                $('#show-meetlink').hide();
                //$('#show-meetlink-datetime').hide();
            }
        })
        $('#course_language').change(function () {
            $.ajax({
                type: 'POST',
                url: '<?php echo e(route("admin.get.courses.by_lang")); ?>',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    'lang':$(this).val()
                },
                datatype: "json",
                success: function (res) {
                    //console.log(res.courses)
                    let $select = $('select[name="course_id"]');
                    $select.empty();
                    $select.append('<option value="" disabled selected>Select One Course</option>');
                    $.each(res.courses, function (index, course) {
                        $select.append(`<option value="${course.id}">${course.title}</option>`);
                    });
                    $select.trigger('change');
                }
            })
            
        })
    });
</script>
<?php $__env->startPush('after-scripts'); ?>



<?php $__env->stopPush(); ?>
<?php echo $__env->make('backend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/stag/tadreeblms/resources/views/backend/assessment_accounts/create__invitation_assignment_course.blade.php ENDPATH**/ ?>