<?php $__env->startSection('title', __('labels.backend.smtp_settings.title').' | '.app_name()); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            
            <div id="smtpAlertContainer"></div>

            
            <form id="smtpSettingsForm" method="POST">
                <?php echo csrf_field(); ?>

                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-sm-5">
                                <h4 class="card-title mb-0">
                                    <i class="fas fa-envelope-open-text mr-2"></i>
                                    <?php echo e(__('labels.backend.smtp_settings.title')); ?>

                                </h4>
                            </div>
                        </div>

                        <hr/>

                        <div class="row mt-4 mb-4">
                            <div class="col">
                                
                                <div class="form-group row">
                                    <label for="mail_mailer" class="col-md-2 form-control-label"><?php echo e(__('labels.backend.smtp_settings.mail_mailer')); ?>*</label>
                                    <div class="col-md-10">
                                        <select name="mail_mailer" id="mail_mailer" class="form-control" required>
                                            <option value="smtp" <?php echo e($smtpSettings['mail_mailer'] == 'smtp' ? 'selected' : ''); ?>>SMTP</option>
                                            <option value="sendmail" <?php echo e($smtpSettings['mail_mailer'] == 'sendmail' ? 'selected' : ''); ?>>Sendmail</option>
                                            <option value="mailgun" <?php echo e($smtpSettings['mail_mailer'] == 'mailgun' ? 'selected' : ''); ?>>Mailgun</option>
                                            <option value="ses" <?php echo e($smtpSettings['mail_mailer'] == 'ses' ? 'selected' : ''); ?>>Amazon SES</option>
                                            <option value="postmark" <?php echo e($smtpSettings['mail_mailer'] == 'postmark' ? 'selected' : ''); ?>>Postmark</option>
                                            <option value="log" <?php echo e($smtpSettings['mail_mailer'] == 'log' ? 'selected' : ''); ?>>Log (for testing)</option>
                                        </select>
                                        <span class="help-text font-italic"><?php echo e(__('labels.backend.smtp_settings.mail_mailer_note')); ?></span>
                                    </div>
                                </div>

                                
                                <div class="form-group row">
                                    <label for="mail_host" class="col-md-2 form-control-label"><?php echo e(__('labels.backend.smtp_settings.mail_host')); ?>*</label>
                                    <div class="col-md-10">
                                        <input type="text" name="mail_host" id="mail_host" class="form-control" value="<?php echo e($smtpSettings['mail_host']); ?>" placeholder="smtp.gmail.com" required>
                                        <span class="help-text font-italic"><?php echo e(__('labels.backend.smtp_settings.mail_host_note')); ?></span>
                                    </div>
                                </div>

                                
                                <div class="form-group row">
                                    <label for="mail_port" class="col-md-2 form-control-label"><?php echo e(__('labels.backend.smtp_settings.mail_port')); ?>*</label>
                                    <div class="col-md-10">
                                        <input type="number" name="mail_port" id="mail_port" class="form-control" value="<?php echo e($smtpSettings['mail_port']); ?>" placeholder="587" required min="1" max="65535">
                                        <span class="help-text font-italic"><?php echo e(__('labels.backend.smtp_settings.mail_port_note')); ?></span>
                                    </div>
                                </div>

                                
                                <div class="form-group row">
                                    <label for="mail_username" class="col-md-2 form-control-label"><?php echo e(__('labels.backend.smtp_settings.mail_username')); ?></label>
                                    <div class="col-md-10">
                                        <input type="text" name="mail_username" id="mail_username" class="form-control" value="<?php echo e($smtpSettings['mail_username']); ?>" placeholder="your-email@gmail.com">
                                        <span class="help-text font-italic"><?php echo e(__('labels.backend.smtp_settings.mail_username_note')); ?></span>
                                    </div>
                                </div>

                                
                                <div class="form-group row">
                                    <label for="mail_password" class="col-md-2 form-control-label"><?php echo e(__('labels.backend.smtp_settings.mail_password')); ?></label>
                                    <div class="col-md-10">
                                        <div class="input-group">
                                            <input type="password" name="mail_password" id="mail_password" class="form-control" placeholder="<?php echo e($smtpSettings['mail_password'] ? '************' : __('labels.backend.smtp_settings.mail_password_placeholder')); ?>">
                                            <div class="input-group-append">
                                                <button class="btn btn-outline-secondary" type="button" id="togglePassword">
                                                    <i class="fas fa-eye" id="toggleIcon"></i>
                                                </button>
                                            </div>
                                        </div>
                                        <span class="help-text font-italic"><?php echo e(__('labels.backend.smtp_settings.mail_password_note')); ?></span>
                                        <?php if($smtpSettings['mail_password']): ?>
                                            <span class="text-muted small d-block mt-1">
                                                <i class="fas fa-info-circle"></i> <?php echo e(__('labels.backend.smtp_settings.password_exists')); ?>

                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                
                                <div class="form-group row">
                                    <label for="mail_encryption" class="col-md-2 form-control-label"><?php echo e(__('labels.backend.smtp_settings.mail_encryption')); ?></label>
                                    <div class="col-md-10">
                                        <select name="mail_encryption" id="mail_encryption" class="form-control">
                                            <option value="tls" <?php echo e($smtpSettings['mail_encryption'] == 'tls' ? 'selected' : ''); ?>>TLS</option>
                                            <option value="ssl" <?php echo e($smtpSettings['mail_encryption'] == 'ssl' ? 'selected' : ''); ?>>SSL</option>
                                            <option value="null" <?php echo e(($smtpSettings['mail_encryption'] == 'null' || $smtpSettings['mail_encryption'] == '') ? 'selected' : ''); ?>>None</option>
                                        </select>
                                        <span class="help-text font-italic"><?php echo e(__('labels.backend.smtp_settings.mail_encryption_note')); ?></span>
                                    </div>
                                </div>

                                
                                <div class="form-group row">
                                    <label for="mail_from_address" class="col-md-2 form-control-label"><?php echo e(__('labels.backend.smtp_settings.mail_from_address')); ?>*</label>
                                    <div class="col-md-10">
                                        <input type="email" name="mail_from_address" id="mail_from_address" class="form-control" value="<?php echo e($smtpSettings['mail_from_address']); ?>" placeholder="noreply@example.com" required>
                                        <span class="help-text font-italic"><?php echo e(__('labels.backend.smtp_settings.mail_from_address_note')); ?></span>
                                    </div>
                                </div>

                                
                                <div class="form-group row">
                                    <label for="mail_from_name" class="col-md-2 form-control-label"><?php echo e(__('labels.backend.smtp_settings.mail_from_name')); ?>*</label>
                                    <div class="col-md-10">
                                        <input type="text" name="mail_from_name" id="mail_from_name" class="form-control" value="<?php echo e($smtpSettings['mail_from_name']); ?>" placeholder="Your Application Name" required>
                                        <span class="help-text font-italic"><?php echo e(__('labels.backend.smtp_settings.mail_from_name_note')); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer clearfix">
                        <div class="row">
                            <div class="col">
                                <a href="<?php echo e(route('admin.smtp-settings')); ?>" class="btn btn-secondary"><?php echo e(__('buttons.general.cancel')); ?></a>
                            </div>
                            <div class="col text-right">
                                <button type="submit" class="btn btn-primary" id="btnSaveSettings">
                                    <i class="fas fa-save mr-1"></i> <?php echo e(__('buttons.general.crud.update')); ?>

                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>

            
            <form id="testEmailForm" method="POST">
                <?php echo csrf_field(); ?>

                <div class="card mt-4">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-sm-5">
                                <h4 class="card-title mb-0">
                                    <i class="fas fa-paper-plane mr-2"></i>
                                    <?php echo e(__('labels.backend.smtp_settings.test_email_title')); ?>

                                </h4>
                            </div>
                        </div>

                        <hr/>

                        <div class="alert alert-info" role="alert">
                            <i class="fas fa-info-circle mr-2"></i>
                            <?php echo e(__('labels.backend.smtp_settings.test_email_info')); ?>

                        </div>

                        <div class="row mt-4 mb-4">
                            <div class="col">
                                <div class="form-group row">
                                    <label for="test_email" class="col-md-2 form-control-label"><?php echo e(__('labels.backend.smtp_settings.test_email_address')); ?>*</label>
                                    <div class="col-md-10">
                                        <input type="email" name="test_email" id="test_email" class="form-control" value="<?php echo e(auth()->user()->email); ?>" placeholder="test@example.com" required>
                                        <span class="help-text font-italic"><?php echo e(__('labels.backend.smtp_settings.test_email_note')); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer clearfix">
                        <div class="row">
                            <div class="col text-right">
                                <button type="submit" class="btn btn-info" id="btnTestEmail">
                                    <i class="fas fa-paper-plane mr-1"></i>
                                    <?php echo e(__('labels.backend.smtp_settings.send_test_email')); ?>

                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>
<script>
$(document).ready(function() {
    // Toggle password visibility
    $('#togglePassword').on('click', function() {
        var passwordField = $('#mail_password');
        var toggleIcon = $('#toggleIcon');
        if (passwordField.attr('type') === 'password') {
            passwordField.attr('type', 'text');
            toggleIcon.removeClass('fa-eye').addClass('fa-eye-slash');
        } else {
            passwordField.attr('type', 'password');
            toggleIcon.removeClass('fa-eye-slash').addClass('fa-eye');
        }
    });

    // Show alert function
    function showAlert(type, message) {
        var alertClass = (type === 'success') ? 'alert-success' : 'alert-danger';
        var iconClass = (type === 'success') ? 'fa-check-circle' : 'fa-exclamation-triangle';
        var html = '<div class="alert ' + alertClass + ' alert-dismissible fade show" role="alert">' +
            '<i class="fas ' + iconClass + ' mr-2"></i>' + message +
            '<button type="button" class="close" data-dismiss="alert"><span>&times;</span></button>' +
            '</div>';
        $('#smtpAlertContainer').html(html);
        window.scrollTo(0, 0);
    }

    // Save SMTP Settings
    $('#smtpSettingsForm').on('submit', function(e) {
        e.preventDefault();

        var btn = $('#btnSaveSettings');
        var btnHtml = btn.html();
        btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin mr-1"></i> <?php echo e(__("labels.backend.smtp_settings.saving")); ?>');

        $.ajax({
            url: '<?php echo e(route("admin.smtp-settings.save")); ?>',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                showAlert('success', response.message || '<?php echo e(__("labels.backend.smtp_settings.save_success")); ?>');
                btn.prop('disabled', false).html(btnHtml);
            },
            error: function(xhr) {
                var msg = '<?php echo e(__("labels.backend.smtp_settings.save_error")); ?>';
                if (xhr.responseJSON) {
                    if (xhr.responseJSON.message) {
                        msg = xhr.responseJSON.message;
                    } else if (xhr.responseJSON.errors) {
                        var errors = [];
                        $.each(xhr.responseJSON.errors, function(key, val) {
                            errors.push(val[0]);
                        });
                        msg = errors.join('<br>');
                    }
                }
                showAlert('error', msg);
                btn.prop('disabled', false).html(btnHtml);
            }
        });
    });

    // Send Test Email
    $('#testEmailForm').on('submit', function(e) {
        e.preventDefault();

        var btn = $('#btnTestEmail');
        var btnHtml = btn.html();
        btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin mr-1"></i> <?php echo e(__("labels.backend.smtp_settings.sending")); ?>');

        $.ajax({
            url: '<?php echo e(route("admin.smtp-settings.test")); ?>',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                showAlert('success', response.message || '<?php echo e(__("labels.backend.smtp_settings.test_email_success")); ?>');
                btn.prop('disabled', false).html(btnHtml);
            },
            error: function(xhr) {
                var msg = '<?php echo e(__("labels.backend.smtp_settings.test_email_error")); ?>';
                if (xhr.responseJSON) {
                    if (xhr.responseJSON.message) {
                        msg = xhr.responseJSON.message;
                    } else if (xhr.responseJSON.errors) {
                        var errors = [];
                        $.each(xhr.responseJSON.errors, function(key, val) {
                            errors.push(val[0]);
                        });
                        msg = errors.join('<br>');
                    }
                }
                showAlert('error', msg);
                btn.prop('disabled', false).html(btnHtml);
            }
        });
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/stag/tadreeblms/resources/views/backend/settings/smtp.blade.php ENDPATH**/ ?>