<?php $__env->startSection('title', __('labels.backend.license_settings.title').' | '.app_name()); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            
            <div id="licenseAlertContainer"></div>

            
            <?php if(!$isConfigured): ?>
                <div class="alert alert-warning" role="alert">
                    <i class="fas fa-exclamation-triangle mr-2"></i>
                    <strong><?php echo e(__('labels.backend.license_settings.not_configured')); ?></strong>
                    <p class="mb-0 mt-2"><?php echo e(__('labels.backend.license_settings.not_configured_note')); ?></p>
                    <code class="d-block mt-2">
                        KEYGEN_ACCOUNT_ID=your-account-id<br>
                        KEYGEN_PRODUCT_ID=your-product-id
                    </code>
                </div>
            <?php endif; ?>

            
            <?php if($stats['is_exceeded']): ?>
                <div class="alert alert-danger" role="alert">
                    <i class="fas fa-exclamation-circle mr-2"></i>
                    <strong><?php echo e(__('labels.backend.license_settings.limit_exceeded')); ?></strong>
                    <p class="mb-0"><?php echo e(__('labels.backend.license_settings.limit_exceeded_note', ['current' => $stats['active_users'], 'max' => $stats['max_users']])); ?></p>
                </div>
            <?php elseif($stats['is_warning']): ?>
                <div class="alert alert-warning" role="alert">
                    <i class="fas fa-exclamation-triangle mr-2"></i>
                    <strong><?php echo e(__('labels.backend.license_settings.limit_warning')); ?></strong>
                    <p class="mb-0"><?php echo e(__('labels.backend.license_settings.limit_warning_note', ['current' => $stats['active_users'], 'max' => $stats['max_users']])); ?></p>
                </div>
            <?php endif; ?>

            
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-6">
                            <h4 class="card-title mb-0">
                                <i class="fas fa-key mr-2"></i>
                                <?php echo e(__('labels.backend.license_settings.title')); ?>

                            </h4>
                        </div>
                        <!-- <div class="col-sm-6 text-right">
                            <?php if($stats['has_license']): ?>
                                <button type="button" class="btn btn-outline-success btn-sm mr-2" id="btnSyncUsers">
                                    <i class="fas fa-users mr-1"></i> Sync Users
                                </button>
                                <button type="button" class="btn btn-outline-primary btn-sm" id="btnRefreshLicense">
                                    <i class="fas fa-sync-alt mr-1"></i> <?php echo e(__('labels.backend.license_settings.validate_now')); ?>

                                </button>
                            <?php endif; ?>
                        </div> -->
                    </div>

                    <hr/>

                    <?php if($stats['has_license']): ?>
                        <?php $license = $stats['license']; ?>

                        <div class="row">
                            
                            <div class="col-md-6">
                                <table class="table table-borderless">
                                    <tr>
                                        <td class="text-muted" width="40%"><?php echo e(__('labels.backend.license_settings.license_key')); ?></td>
                                        <td>
                                            <code id="maskedKey"><?php echo e($license->masked_key); ?></code>
                                            <button type="button" class="btn btn-link btn-sm p-0 ml-2" id="toggleKeyVisibility" title="Show/Hide">
                                                <i class="fas fa-eye" id="keyVisibilityIcon"></i>
                                            </button>
                                            <span id="fullKey" class="d-none"><?php echo e($license->license_key); ?></span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="text-muted"><?php echo e(__('labels.backend.license_settings.status')); ?></td>
                                        <td>
                                            <span class="badge badge-<?php echo e($license->status_badge_class); ?> px-3 py-2">
                                                <?php echo e($license->status_label); ?>

                                            </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="text-muted"><?php echo e(__('labels.backend.license_settings.license_type')); ?></td>
                                        <td><?php echo e(ucfirst($license->license_type ?? 'Standard')); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="text-muted"><?php echo e(__('labels.backend.license_settings.licensed_to')); ?></td>
                                        <td><?php echo e($license->licensed_to ?? '-'); ?></td>
                                    </tr>
                                    <?php if($license->licensee_email): ?>
                                    <tr>
                                        <td class="text-muted"><?php echo e(__('labels.backend.license_settings.licensee_email')); ?></td>
                                        <td><?php echo e($license->licensee_email); ?></td>
                                    </tr>
                                    <?php endif; ?>
                                </table>
                            </div>

                            
                            <div class="col-md-6">
                                <table class="table table-borderless">
                                    <tr>
                                        <td class="text-muted" width="40%"><?php echo e(__('labels.backend.license_settings.max_users')); ?></td>
                                        <td><?php echo e($stats['max_users'] ?? __('labels.backend.license_settings.unlimited')); ?></td>
                                    </tr>
                                    <tr>
                                        <td class="text-muted"><?php echo e(__('labels.backend.license_settings.active_users')); ?></td>
                                        <td>
                                            <span class="<?php echo e($stats['is_exceeded'] ? 'text-danger font-weight-bold' : ''); ?>">
                                                <?php echo e($stats['active_users']); ?>

                                            </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="text-muted"><?php echo e(__('labels.backend.license_settings.remaining_users')); ?></td>
                                        <td>
                                            <?php if($stats['remaining_users'] !== null): ?>
                                                <span class="<?php echo e($stats['remaining_users'] <= 0 ? 'text-danger' : ($stats['remaining_users'] <= 5 ? 'text-warning' : 'text-success')); ?>">
                                                    <?php echo e(max(0, $stats['remaining_users'])); ?>

                                                </span>
                                            <?php else: ?>
                                                <?php echo e(__('labels.backend.license_settings.unlimited')); ?>

                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="text-muted"><?php echo e(__('labels.backend.license_settings.expiry_date')); ?></td>
                                        <td>
                                            <?php if($license->expiry_date): ?>
                                                <?php echo e($license->expiry_date->format('M d, Y')); ?>

                                                <?php if($license->expiry_date->isPast()): ?>
                                                    <span class="badge badge-danger ml-2"><?php echo e(__('labels.backend.license_settings.expired')); ?></span>
                                                <?php elseif($license->expiry_date->diffInDays(now()) <= 30): ?>
                                                    <span class="badge badge-warning ml-2"><?php echo e($license->expiry_date->diffForHumans()); ?></span>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <?php echo e(__('labels.backend.license_settings.never')); ?>

                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="text-muted"><?php echo e(__('labels.backend.license_settings.support_until')); ?></td>
                                        <td>
                                            <?php if($license->support_valid_until): ?>
                                                <?php echo e($license->support_valid_until->format('M d, Y')); ?>

                                                <?php if($license->support_valid_until->isPast()): ?>
                                                    <span class="badge badge-secondary ml-2"><?php echo e(__('labels.backend.license_settings.expired')); ?></span>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                -
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="text-muted"><?php echo e(__('labels.backend.license_settings.last_validated')); ?></td>
                                        <td>
                                            <?php echo e($license->last_validated_at ? $license->last_validated_at->diffForHumans() : '-'); ?>

                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>

                        
                        <?php if($stats['max_users']): ?>
                            <div class="mt-3">
                                <label class="text-muted"><?php echo e(__('labels.backend.license_settings.user_usage')); ?></label>
                                <div class="progress" style="height: 25px;">
                                    <?php
                                        $progressClass = 'bg-success';
                                        if ($stats['usage_percentage'] >= 100) {
                                            $progressClass = 'bg-danger';
                                        } elseif ($stats['usage_percentage'] >= 90) {
                                            $progressClass = 'bg-warning';
                                        } elseif ($stats['usage_percentage'] >= 75) {
                                            $progressClass = 'bg-info';
                                        }
                                    ?>
                                    <div class="progress-bar <?php echo e($progressClass); ?>" role="progressbar"
                                         style="width: <?php echo e(min(100, $stats['usage_percentage'])); ?>%"
                                         aria-valuenow="<?php echo e($stats['active_users']); ?>"
                                         aria-valuemin="0"
                                         aria-valuemax="<?php echo e($stats['max_users']); ?>">
                                        <?php echo e($stats['active_users']); ?> / <?php echo e($stats['max_users']); ?> <?php echo e(__('labels.backend.license_settings.users')); ?>

                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                    <?php else: ?>
                        
                        <div class="text-center py-5">
                            <i class="fas fa-key fa-4x text-muted mb-3"></i>
                            <h5 class="text-muted"><?php echo e(__('labels.backend.license_settings.no_license')); ?></h5>
                            <p class="text-muted"><?php echo __('labels.backend.license_settings.no_license_note'); ?></p>
                        </div>
                    <?php endif; ?>
                </div>

                <?php if($stats['has_license']): ?>
                    <div class="card-footer">
                        <button type="button" class="btn btn-danger btn-sm" id="btnRemoveLicense">
                            <i class="fas fa-trash mr-1"></i> <?php echo e(__('labels.backend.license_settings.remove_license')); ?>

                        </button>
                    </div>
                <?php endif; ?>
            </div>

            
            <div class="card mt-4">
                <div class="card-body">
                    <h4 class="card-title mb-0">
                        <i class="fas fa-plus-circle mr-2"></i>
                        <?php echo e($stats['has_license'] ? __('labels.backend.license_settings.update_license') : __('labels.backend.license_settings.activate_license')); ?>

                    </h4>

                    <hr/>

                    <form id="licenseForm">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label for="license_key"><?php echo e(__('labels.backend.license_settings.enter_license_key')); ?></label>
                            <div class="input-group">
                                <input type="text" name="license_key" id="license_key" class="form-control"
                                       placeholder="<?php echo e(__('labels.backend.license_settings.license_key_placeholder')); ?>" required>
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-primary" id="btnActivate">
                                        <i class="fas fa-check mr-1"></i> <?php echo e(__('labels.backend.license_settings.activate')); ?>

                                    </button>
                                </div>
                            </div>
                            <small class="form-text text-muted"><?php echo e(__('labels.backend.license_settings.license_key_note')); ?></small>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="removeLicenseModal" tabindex="-1" aria-labelledby="removeLicenseModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body text-center py-4">
                    <div class="mb-4">
                        <div class="d-inline-flex align-items-center justify-content-center rounded-circle bg-danger bg-opacity-10" style="width: 80px; height: 80px; background-color: rgba(220, 53, 69, 0.1);">
                            <i class="fas fa-exclamation-triangle text-danger fa-2x"></i>
                        </div>
                    </div>
                    <h5 class="mb-2"><?php echo e(__('labels.backend.license_settings.remove_license_title')); ?></h5>
                    <p class="text-muted mb-4"><?php echo e(__('labels.backend.license_settings.remove_confirm')); ?></p>
                    <div class="d-flex justify-content-center gap-2">
                        <button type="button" class="btn btn-outline-secondary mr-2" data-dismiss="modal">
                            <?php echo e(__('labels.general.buttons.cancel')); ?>

                        </button>
                        <button type="button" class="btn btn-danger" id="btnConfirmRemoveLicense">
                            <i class="fas fa-trash mr-1"></i> <?php echo e(__('labels.backend.license_settings.remove_license')); ?>

                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>
<script>
$(document).ready(function() {
    // Show alert function
    function showAlert(type, message) {
        var alertClass = (type === 'success') ? 'alert-success' : 'alert-danger';
        var iconClass = (type === 'success') ? 'fa-check-circle' : 'fa-exclamation-triangle';
        var html = '<div class="alert ' + alertClass + ' alert-dismissible fade show" role="alert">' +
            '<i class="fas ' + iconClass + ' mr-2"></i>' + message +
            '<button type="button" class="close" data-dismiss="alert"><span>&times;</span></button>' +
            '</div>';
        $('#licenseAlertContainer').html(html);
        window.scrollTo(0, 0);
    }

    // Toggle license key visibility
    var keyVisible = false;
    $('#toggleKeyVisibility').on('click', function() {
        keyVisible = !keyVisible;
        if (keyVisible) {
            $('#maskedKey').text($('#fullKey').text());
            $('#keyVisibilityIcon').removeClass('fa-eye').addClass('fa-eye-slash');
        } else {
            $('#maskedKey').text('<?php echo e($stats["has_license"] ? $stats["license"]->masked_key : ""); ?>');
            $('#keyVisibilityIcon').removeClass('fa-eye-slash').addClass('fa-eye');
        }
    });

    // Activate License
    $('#licenseForm').on('submit', function(e) {
        e.preventDefault();

        var btn = $('#btnActivate');
        var btnHtml = btn.html();
        btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin mr-1"></i> <?php echo e(__("labels.backend.license_settings.activating")); ?>');

        $.ajax({
            url: '<?php echo e(route("admin.license.activate")); ?>',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                showAlert('success', response.message);
                setTimeout(function() {
                    location.reload();
                }, 1500);
            },
            error: function(xhr) {
                var msg = '<?php echo e(__("labels.backend.license_settings.activation_failed")); ?>';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    msg = xhr.responseJSON.message;
                }
                showAlert('error', msg);
                btn.prop('disabled', false).html(btnHtml);
            }
        });
    });

    // Sync Users to Keygen
    $('#btnSyncUsers').on('click', function() {
        var btn = $(this);
        var btnHtml = btn.html();
        btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin mr-1"></i> Syncing...');

        $.ajax({
            url: '<?php echo e(route("admin.license.sync-users")); ?>',
            type: 'POST',
            data: { _token: '<?php echo e(csrf_token()); ?>' },
            dataType: 'json',
            success: function(response) {
                var details = 'Total: ' + (response.total || 0) +
                    ', Created: ' + (response.created || 0) +
                    ', Attached: ' + (response.attached || 0) +
                    ', Failed: ' + (response.failed || 0);
                showAlert('success', response.message + ' (' + details + ')');
                btn.prop('disabled', false).html(btnHtml);
                setTimeout(function() {
                    location.reload();
                }, 2000);
            },
            error: function(xhr) {
                var msg = 'Failed to sync users';
                var details = '';
                if (xhr.responseJSON) {
                    if (xhr.responseJSON.message) {
                        msg = xhr.responseJSON.message;
                    }
                    details = ' (Total: ' + (xhr.responseJSON.total || 0) +
                        ', Created: ' + (xhr.responseJSON.created || 0) +
                        ', Failed: ' + (xhr.responseJSON.failed || 0) + ')';
                    if (xhr.responseJSON.errors && xhr.responseJSON.errors.length > 0) {
                        details += '<br><small>' + xhr.responseJSON.errors.join('<br>') + '</small>';
                    }
                }
                showAlert('error', msg + details);
                btn.prop('disabled', false).html(btnHtml);
            }
        });
    });

    // Refresh/Validate License
    $('#btnRefreshLicense').on('click', function() {
        var btn = $(this);
        var btnHtml = btn.html();
        btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin mr-1"></i>');

        $.ajax({
            url: '<?php echo e(route("admin.license.validate")); ?>',
            type: 'POST',
            data: { _token: '<?php echo e(csrf_token()); ?>' },
            dataType: 'json',
            success: function(response) {
                showAlert('success', response.message);
                if (!response.cached) {
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                }
                btn.prop('disabled', false).html(btnHtml);
            },
            error: function(xhr) {
                var msg = '<?php echo e(__("labels.backend.license_settings.validation_failed")); ?>';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    msg = xhr.responseJSON.message;
                }
                showAlert('error', msg);
                btn.prop('disabled', false).html(btnHtml);
            }
        });
    });

    // Remove License - Show confirmation modal
    $('#btnRemoveLicense').on('click', function() {
        $('#removeLicenseModal').modal('show');
    });

    // Confirm Remove License
    $('#btnConfirmRemoveLicense').on('click', function() {
        var btn = $(this);
        var btnHtml = btn.html();
        btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin mr-1"></i> <?php echo e(__("labels.backend.license_settings.removing")); ?>');

        $.ajax({
            url: '<?php echo e(route("admin.license.remove")); ?>',
            type: 'POST',
            data: { _token: '<?php echo e(csrf_token()); ?>' },
            dataType: 'json',
            success: function(response) {
                $('#removeLicenseModal').modal('hide');
                showAlert('success', response.message);
                setTimeout(function() {
                    location.reload();
                }, 1500);
            },
            error: function(xhr) {
                var msg = '<?php echo e(__("labels.backend.license_settings.remove_failed")); ?>';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    msg = xhr.responseJSON.message;
                }
                $('#removeLicenseModal').modal('hide');
                showAlert('error', msg);
                btn.prop('disabled', false).html(btnHtml);
            }
        });
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('backend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/stag/tadreeblms/resources/views/backend/settings/license.blade.php ENDPATH**/ ?>