<?php $__env->startSection('title', __('labels.backend.questions.title').' | '.app_name()); ?>

<?php $__env->startSection('content'); ?>
<form method="POST" action="<?php echo e(route('admin.test_questions.store')); ?>" enctype="multipart/form-data">
<?php echo csrf_field(); ?>
<?php $__env->startPush('after-styles'); ?>
<style>
    :root {
        --primary-color: #4e73df;
        --secondary-color: #858796;
        --success-color: #1cc88a;
        --info-color: #36b9cc;
        --warning-color: #f6c23e;
        --danger-color: #e74a3b;
        --light-color: #f8f9fc;
        --dark-color: #5a5c69;
        --card-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
    }

    .question-builder-container {
        padding: 20px 0;
    }
 

    .card-header {
        background-color: #fff !important;
        border-bottom: 1px solid #f2f4f9 !important;
        border-radius: 12px 12px 0 0 !important;
        padding: 1.25rem !important;
    }

    .card-header h5 {
        color: #4e73df;
        font-weight: 700;
        margin: 0;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .form-group label {
        font-weight: 600;
        color: #4a5568;
        margin-bottom: 8px;
        font-size: 0.9rem;
    }

    .form-control {
        border-radius: 8px;
        padding: 12px 15px;
        border: 1px solid #e2e8f0;
        transition: border-color 0.2s, box-shadow 0.2s;
    }

    .form-control:focus {
        border-color: #4e73df;
        box-shadow: 0 0 0 3px rgba(78, 115, 223, 0.1);
    }

    /* Options Builder Styling */
    .option-item {
        background: #f8fafc;
        border: 1px solid #e2e8f0;
        border-radius: 10px;
        padding: 15px;
        margin-bottom: 12px;
        display: flex;
        align-items: center;
        gap: 15px;
        transition: all 0.2s;
        position: relative;
    }

    .option-item:hover {
        border-color: #cbd5e0;
        background: #f1f5f9;
        transform: translateY(-2px);
    }

    .option-item .drag-handle {
        cursor: grab;
        color: #cbd5e0;
    }

    .option-item .option-content {
        flex-grow: 1;
        font-size: 0.95rem;
    }

    .option-item .option-actions {
        display: flex;
        gap: 8px;
    }

    .option-item.correct {
        border-left: 4px solid #1cc88a;
        background: #f0fff4;
    }

    /* Floating Preview Styling */
    .preview-panel {
        position: sticky;
        top: 20px;
        z-index: 100;
    }

    .preview-card {
        background: #fff;
        border-top: 4px solid #4e73df;
    }

    .preview-header {
        background: #f8fafc;
        padding: 15px;
        border-bottom: 1px solid #e2e8f0;
        font-weight: 700;
        color: #2d3748;
        text-transform: uppercase;
        font-size: 0.8rem;
        letter-spacing: 0.05em;
    }

    .preview-body {
        padding: 24px;
        max-height: 80vh;
        overflow-y: auto;
    }

    .badge-difficulty {
        padding: 5px 12px;
        border-radius: 20px;
        font-size: 0.75rem;
        font-weight: 700;
        text-transform: uppercase;
    }

    .badge-easy { background: #def7ec; color: #03543f; }
    .badge-medium { background: #fef3c7; color: #92400e; }
    .badge-hard { background: #fde8e8; color: #9b1c1c; }

    /* Sticky Footer */
    .sticky-footer {
        position: fixed;
        bottom: 0;
        left: 0;
        right: 0;
        background: rgba(255, 255, 255, 0.9);
        backdrop-filter: blur(10px);
        padding: 15px 30px;
        box-shadow: 0 -5px 20px rgba(0,0,0,0.05);
        z-index: 1000;
        display: flex;
        justify-content: space-between;
        align-items: center;
        border-top: 1px solid #e2e8f0;
    }

    .main {
        padding-bottom: 80px !important; /* Space for footer */
    }

    /* Custom Radio/Checkbox */
    .custom-control-input:checked ~ .custom-control-label::before {
        background-color: #4e73df;
        border-color: #4e73df;
    }

    /* Helper spacing */
    .gap-10 { gap: 10px; }
    .mt-auto { margin-top: auto; }
</style>
<?php $__env->stopPush(); ?>




<?php echo $__env->make('backend.includes.partials.course-steps', ['step' => 3, 'course_id' => $course_id, 'course' => $course ?? null ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>


 <div class="pb-3 d-flex justify-content-between align-items-center addcourseheader">
       <h4>
           <?php echo app('translator')->get('labels.backend.questions.create'); ?>
       </h4>
         <div class="">
       <a href="<?php echo e(route('admin.test_questions.index')); ?>" class="btn btn-primary"><?php echo app('translator')->get('labels.backend.questions.view'); ?></a>
   </div>
     
   </div>
<div class="card">
    <!-- <div class="card-header">
        <h3 class="page-title float-left mb-0"><?php echo app('translator')->get('labels.backend.questions.create'); ?></h3>
        <div class="float-right">
            <a href="<?php echo e(route('admin.test_questions.index')); ?>" class="btn btn-success"><?php echo app('translator')->get('labels.backend.questions.view'); ?></a>
        </div>
    </div> -->
    <div class="card-body">
        <input type="hidden" id="temp_id" name="temp_id" value="<?php echo e($temp_id); ?>">
        <input type="hidden" id="action_btn" name="action_btn" value="">
        <input type="hidden" id="course_id" name="course_id" value="<?php echo e($course_id); ?>">
        <div class="row mt-3">
            <div class="col-12 col-md-6">
                <label>Test</label>
                <div class="custom-select-wrapper">

                    <select <?php if($auto_test_id): ?> disabled <?php endif; ?> class="form-control custom-select-box" name="test_id" id="test_id" required>
                        <option value="">Select Test</option>
                        <?php $__currentLoopData = $tests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option <?php if((request()->get('test_id') == $value->id) || ($auto_test_id == $value->id)): ?> selected <?php endif; ?> value="<?php echo e($value->id); ?>"><?php echo e($value->title); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                     <span class="custom-select-icon">
        <i class="fa fa-chevron-down"></i>
    </span>
                </div>
            </div>
         
            <div class="col-12 col-md-6">
                <label>Question Type</label>
                <div class="custom-select-wrapper">

                    <select class="form-control custom-select-box" name="question_type" id="question_type">
                        <option value="1"> Single Choice </option>
                        
                    </select>
                     <span class="custom-select-icon">
        <i class="fa fa-chevron-down"></i>
    </span>
                </div>
            </div>
        </div>



        <div class="row">
          <div class="col-12 col-md-6 mt-3 notextarea"> 
                <label>Question</label>
                <textarea class="form-control editor" rows="3" name="question" id="question" required="required"></textarea>
            </div>
         
                <div class="col-12 col-md-6"> 
                     <div class="mt-3 notextarea">
                    <label>Option</label>
                    <textarea class="form-control editor" rows="3" name="option" id="option" required="required"></textarea>
                    <div class="addoptbtn">
                    <button type="button" id="add_option" class="btn btn-primary mt-2">Add Option</button>
                </div>
              <div class="addoptiontable ">
                    <div id="option-area" class=""></div>
                </div>
               </div>
            </div>
</div>


            <div class="row">
                 <div class="col-12 col-md-5 notextarea">
                    <label>Solution</label>
                    <textarea class="form-control textarea-col editor" rows="3" name="solution" id="solution"></textarea>
                </div>
             
             <div class="col-12 col-md-2">
                    <label>Marks</label>
                    <input type="number" class="form-control" name="marks" id="marks" placeholder="Enter Marks" required />
                </div>
             
                <div class="col-12 col-md-5 notextarea">
                    <label>Comment</label>
                    <textarea class="form-control textarea-col editor" rows="3" name="comment" id="comment"></textarea>

         

         
        </div>
        </div>

<!--
<div class="row">
        <div class="col-md-6">
     Options Builder Card  
            <div class="" id="options-card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5><i class="fa fa-list-ul"></i> Options Builder</h5>
                    <button type="button" class="btn btn-sm btn-outline-primary" id="add_option_btn">
                        <i class="fa fa-plus"></i> Add Option
                    </button>
                </div>
                <div class="card-body">
                   New Option Input (Floating)  
                    <div id="option-input-wrapper" class="mb-4 bg-light p-3 rounded shadow-sm" style="display:none;">
                        <label>New Option Content</label>
                        <textarea class="form-control editor" name="option_editor" id="option_editor"></textarea>
                        <div class="mt-2 text-right">
                            <button type="button" class="btn btn-secondary btn-sm" id="cancel_option">Cancel</button>
                            <button type="button" class="btn btn-primary btn-sm" id="confirm_add_option">Add this Option</button>
                        </div>
                    </div>

                    <div id="option-area" class="mt-3">
                        <div class="text-center py-4 text-muted">
                            <i class="fa fa-info-circle fa-2x mb-2"></i>
                            <p>No options added yet. Click "Add Option" to begin.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6">
     Solution & Comments Card  
            <div class=" ">
                <div class="card-header">
                    <h5><i class="fa fa-check-circle"></i> Explanation & Feedback</h5>
                </div>
                <div class="card-body">
                    <div class="form-group">
                        <label>Correct Solution / Explanation</label>
                        <textarea class="form-control editor" rows="3" name="solution" id="solution"></textarea>
                    </div>
                    <div class="form-group mt-3">
                        <label>Admin Comments (Internal)</label>
                        <textarea class="form-control editor" rows="3" name="comment" id="comment"></textarea>
                    </div>
                </div>
            </div>
        </div>
</div>
-->
<!--
<div class="row">
         Right Panel: Live Preview  
        <div class="col-lg-12">
            <div class="preview-panel">
                <div class="card preview-card">
                    <div class="preview-header">
                        <i class="fa fa-eye"></i> Learner Preview
                    </div>
                    <div class="preview-body" id="live-preview-content">
                        <div class="preview-meta mb-3 d-flex justify-content-between align-items-center">
                            <span id="preview-marks" class="badge badge-info">0 Marks</span>
                            <span id="preview-difficulty" class="badge-difficulty badge-easy">Easy</span>
                        </div>
                        <div id="preview-tags" class="mb-3"></div>
                        <div id="preview-question" class="question-text mb-4" style="font-size: 1.1rem; font-weight: 500;">
                            <span class="text-muted italic">Question content will appear here...</span>
                        </div>
                        <div id="preview-options" class="options-preview">
                            Preview options will appear here  
                        </div>
                        <div id="preview-hint" class="mt-3 d-none">
                            <div class="alert alert-warning py-2 small">
                                <strong>Hint:</strong> <span id="preview-hint-text"></span>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer bg-white py-3">
                        <small class="text-muted"><i class="fa fa-mobile-alt"></i> Optimized for all devices</small>
                    </div>
                </div>
            </div>
        </div>
        </div>
    </div>
</div>
-->


     <div class="btmbtns">
        <div class="row">
    <div class="col-12 mt-5 buttons">
        
     <button type="button" class="frm_submit add-btn" id="save_and_add_more" value="save_and_add_more">Save & Add More</button>
    
     <span class="text-right pull-right">
        <button
            type="button"
            class="frm_submit cancel-btn"
            id="save_as_draft"
            value="Save As Draft">
            Save As Draft
        </button>

        <button
            type="button"
            class="frm_submit add-btn"
            id="save"
            value="Next">
            Next
        </button>
</span>
    </div>
    
</div>
</div>



</form>
<script src="<?php echo e(asset('ckeditor/ckeditor.js')); ?>" type="text/javascript"></script>
<script type="text/javascript">

    $('.frm_submit').on('click', function (){
        //alert($(this).val())
        $('#action_btn').val($(this).val());
    });

    CKEDITOR.replace('question');
    
    CKEDITOR.replace('option');
    
    CKEDITOR.replace('solution');
    
    CKEDITOR.replace('comment')
    
</script>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('after-scripts'); ?>

<script type="text/javascript">
    var options = [];
    var flag = 0;

    function removeOptions(pos) {
        options.splice(pos, 1);
        showOptions();
    }

    function markAsCorrectOption(pos, show_remove_options = true) {
        for (var i = 0; i < options.length; ++i) {
            if ($('#question_type').val() == 1) {
                if (i === pos) {
                    options[i][1] = 1;
                } else {
                    options[i][1] = 0;
                }
            } else {
                if (i === pos) {
                    if (options[i][1] == 1) {
                        options[i][1] = 0;
                    } else {
                        options[i][1] = 1;
                    }
                } else {
                    options[i][1] = options[i][1];
                }
            }
        }
        showOptions(show_remove_options);
    }

    function showOptions(show_remove_options = true) {
        if (show_remove_options == true) {
            var option_text = '<table class="table table-bordered table-striped"><tbody><tr><th>Option</th>';
            var drag_drop_question_type = $('#question_type').val();
            option_text += '<th>Is Right</th></tr>';
            for (var i = 0; i < options.length; ++i) {
                option = options[i];
                option_text += '<tr>';
                option_text += '<td>' + option[0] + '</td>';
                if (parseInt($('#question_type').val()) == 1) {
                    option_text += '<td><input type="radio" ';
                } else {
                    option_text += '<td><input type="checkbox" class="cb_checkbox_mark" ';
                }
                if (option[1] === 1) {
                    option_text += 'checked="checked"';
                }
                option_text += ' onclick="markAsCorrectOption(' + i + ')"></td>';
                option_text += '<td><a href="javascript:void(0);"  onclick="removeOptions(' + i + ')" class="btn btn-danger remove"><i class="la la-trash"></i>Remove</a>';
                option_text += '</tr>'
            }
            option_text += '</tbody></table>';
            $('#option-area').html(option_text);
        } else {
            var option_text = '<table class="table table-bordered table-striped"><tbody><tr><th>Option</th><th>Is Right</th></tr>';
            for (var i = 0; i < options.length; ++i) {
                option = options[i];
                option_text += '<tr>';
                option_text += '<td>' + option[0] + '</td>';
                option_text += '<td><input type="radio" ';
                if (option[1] === 1) {
                    option_text += 'checked="checked"';
                }
                option_text += ' onclick="markAsCorrectOption(' + i + ',false)"></td>';
                option_text += '</tr>'
            }
            option_text += '</tbody></table>';
            document.getElementById('option-area').innerHTML = option_text;
        }
        addImgClass();
    }

    function addOptions() {
        var option = CKEDITOR.instances["option"].getData();
        options_length = (options != null && options != undefined) ? options.length : 0;
        options.push([option.trim(), 0]);
        CKEDITOR.instances["option"].setData('');
    }

    $(document).on('click', "#add_option", function() {
        if (CKEDITOR.instances["option"].getData() != "") {
            // if ((options.length + 1) <= 4) {
                addOptions();
            // } else {
            //     alert('You can use only 4 Options.');
            // }
        }
        showOptions();
    });

    function addImgClass() {
        $('#option-area').each(function() {
            $(this).find('img').addClass('img-fluid');
        });
    }

    function dataCollection() {
        var temp_id = $("#temp_id").val();
        var test_id = $("#test_id").val();
        var question_type = $("#question_type").val();
        var question = CKEDITOR.instances["question"].getData();
        var solution = CKEDITOR.instances["solution"].getData();
        var comment = CKEDITOR.instances["comment"].getData();
        var marks = $("#marks").val();
        return {
            temp_id,
            test_id,
            question_type,
            question,
            options: JSON.stringify(options),
            solution,
            comment,
            marks
        }
    }

    $(document).on('click', ".frm_submit", function() {
        flag = 0;
        sendData();
        /*
        if (CKEDITOR.instances["question"].getData() != "" && $('#marks').val() != "" && $('#test_id').val() != "") {
            if ($('#question_type').val() == 1) {
                if ($('input:radio:checked').length > 0) {
                    sendData();
                } else {
                    alert('Please Select The Right Answer.');
                }
            } else if ($('#question_type').val() == 2) {
                if ($('input:checkbox:checked').length > 0) {
                    sendData();
                } else {
                    alert('Please Select at least one right Answer.');
                }
            } else {
                sendData();
            }
        } else {
            alert("Please fill all the details.");
        }
        */
    });

    var question_submit_url = "<?php echo e(route('admin.test_questions.store')); ?>";

    function sendData(data) {
        var data = dataCollection();
        data['_token'] = "<?php echo e(csrf_token()); ?>";
        data['action_btn'] = $('#action_btn').val();
        data['course_id'] = $('#course_id').val();
        const redirect = "<?php echo e(request()->redirect); ?>";
        $.ajax({
            url: question_submit_url,
            type: 'post',
            data: data,
            success: function(response) {
                response = JSON.parse(response);
                if (response.code == 200) {
                    // if (data['action_btn'] == 'save_and_add_more') {
                    //     window.location.replace(response.redirect_url);
                    // }else{
                    //     window.location.replace(redirect);
                    // }
                    window.location.replace(response.redirect_url);
                } else {
                    alert(response.message);
                }
            },
            error: function (xhr) {
                if (xhr.status === 422) {
                    let res = xhr.responseJSON;
                    alert(res.message); // Show the error message
                    console.log('Validation errors:', res.errors);
                }
            }
        });
    }

    $(document).on('change', '#question_type', function() {
        var question_type = $(this).val();
        $.ajax({
            url: "<?php echo e(route('admin.test_questions.question_setup')); ?>",
            type: 'post',
            data: ({
                question_type: question_type,
                _token: "<?php echo e(csrf_token()); ?>"
            }),
            success: function(response) {
                $('.cb_question_setup').html(response);
                // if (response.code == 200) {
                //     $('.cb_question_setup').html(response.question_setup);
                // } else {
                //     alert(response.message);
                // }
                // console.log(response);
            },
        });
    });
</script>
<!-- <script type="text/javascript">
    var options = [];
    var currentOptionId = null;

function removeOptions(pos) {
        options.splice(pos, 1);
        showOptions();
    }

    $(document).ready(function() {
        // Initialize CKEditors
        const editorIds = ['question', 'solution', 'comment', 'option_editor'];
        editorIds.forEach(id => {
            if (CKEDITOR.instances[id]) {
                CKEDITOR.instances[id].on('change', function() {
                    updatePreview();
                });
            }
        });

        // Event listeners for preview updates
        $('#marks, #difficulty, #tags, #hint, #question_type').on('input change', function() {
            updatePreview();
        });

        // Initial preview
        updatePreview();
    });

    function updatePreview() {
        // Update Marks
        $('#preview-marks').text(($('#marks').val() || 0) + ' Marks');

        // Update Difficulty
        const diff = $('#difficulty').val();
        $('#preview-difficulty').text(diff.charAt(0).toUpperCase() + diff.slice(1))
            .removeClass('badge-easy badge-medium badge-hard')
            .addClass('badge-' + diff);

        // Update Tags
        const tags = $('#tags').val();
        if (tags) {
            let tagHtml = tags.split(',').map(t => `<span class="badge badge-secondary mr-1">${t.trim()}</span>`).join('');
            $('#preview-tags').html(tagHtml);
        } else {
            $('#preview-tags').empty();
        }

        // Update Question Text
        const questionText = CKEDITOR.instances['question'].getData();
        if (questionText) {
            $('#preview-question').html(questionText);
        } else {
            $('#preview-question').html('<span class="text-muted italic">Question content will appear here...</span>');
        }

        // Update Hint
        const hint = $('#hint').val();
        if (hint) {
            $('#preview-hint').removeClass('d-none');
            $('#preview-hint-text').text(hint);
        } else {
            $('#preview-hint').addClass('d-none');
        }

        renderOptionsPreview();
    }

    function renderOptionsPreview() {
        const type = $('#question_type').val();
        let html = '';
        
        if (type == 3) {
            html = '<div class="alert alert-light border text-muted px-4 py-3">Learners will provide a descriptive answer here.</div>';
        } else {
            options.forEach((opt, index) => {
                const inputType = type == 1 ? 'radio' : 'checkbox';
                html += `
                    <div class="custom-control custom-${inputType} mb-2">
                        <input type="${inputType}" class="custom-control-input" id="prev_opt_${index}" name="prev_opt" value="${index}">
                        <label class="custom-control-label" for="prev_opt_${index}">${opt[0]}</label>
                    </div>
                `;
            });
        }
        $('#preview-options').html(html || '<span class="text-muted small italic">Options will appear here...</span>');
    }

    // Options Management
    $(document).on('click', '#add_option_btn', function() {
        $('#option-input-wrapper').slideDown();
        CKEDITOR.instances['option_editor'].setData('');
        $(this).hide();
    });

    $(document).on('click', '#cancel_option', function() {
        $('#option-input-wrapper').slideUp();
        $('#add_option_btn').show();
    });

    $(document).on('click', '#confirm_add_option', function() {
        const content = CKEDITOR.instances['option_editor'].getData().trim();
        if (!content) {
            alert('Please enter option content');
            return;
        }

        options.push([content, 0]); // [content, is_right]
        renderOptionsList();
        updatePreview();
        
        $('#option-input-wrapper').slideUp();
        $('#add_option_btn').show();
    });

    function removeOption(index) {
        options.splice(index, 1);
        renderOptionsList();
        updatePreview();
    }

     function showOptions(show_remove_options = true) {
        if (show_remove_options == true) {
            var option_text = '<table class="table table-bordered table-striped"><tbody><tr><th>Option</th>';
            var drag_drop_question_type = $('#question_type').val();
            option_text += '<th>Is Right</th></tr>';
            for (var i = 0; i < options.length; ++i) {
                option = options[i];
                option_text += '<tr>';
                option_text += '<td>' + option[0] + '</td>';
                if (parseInt($('#question_type').val()) == 1) {
                    option_text += '<td><input type="radio" ';
                } else {
                    option_text += '<td><input type="checkbox" class="cb_checkbox_mark" ';
                }
                if (option[1] === 1) {
                    option_text += 'checked="checked"';
                }
                option_text += ' onclick="markAsCorrectOption(' + i + ')"></td>';
                option_text += '<td><a href="javascript:void(0);"  onclick="removeOptions(' + i + ')" class="btn btn-danger remove"><i class="la la-trash"></i>Remove</a>';
                option_text += '</tr>'
            }
            option_text += '</tbody></table>';
            $('#option-area').html(option_text);
        } else {
            var option_text = '<table class="table table-bordered table-striped"><tbody><tr><th>Option</th><th>Is Right</th></tr>';
            for (var i = 0; i < options.length; ++i) {
                option = options[i];
                option_text += '<tr>';
                option_text += '<td>' + option[0] + '</td>';
                option_text += '<td><input type="radio" ';
                if (option[1] === 1) {
                    option_text += 'checked="checked"';
                }
                option_text += ' onclick="markAsCorrectOption(' + i + ',false)"></td>';
                option_text += '</tr>'
            }
            option_text += '</tbody></table>';
            document.getElementById('option-area').innerHTML = option_text;
        }
        addImgClass();
    }
    function addOptions() {
        var option = CKEDITOR.instances["option"].getData();
        options_length = (options != null && options != undefined) ? options.length : 0;
        options.push([option.trim(), 0]);
        CKEDITOR.instances["option"].setData('');
    }

    //$(document).on('click', "#add_option", function() {
        //if (CKEDITOR.instances["option"].getData() != "") {
            // if ((options.length + 1) <= 4) {
                //addOptions();
            // } else {
            //     alert('You can use only 4 Options.');
            // }
       // }
       // showOptions();
   // });

 $(document).on('click', "#add_option", function() {
    // 1. Get data from CKEditor
    var rawContent = CKEDITOR.instances["option"].getData();

    // 2. Strip HTML tags to see if there is actually any text
    // This removes <p>, <br>, and converts &nbsp; to empty space
    var plainText = rawContent.replace(/<[^>]*>/g, '').replace(/&nbsp;/g, '').trim();

    // 3. Validation Check
    if (plainText === "") {
        alert("Please enter text for the option before adding it.");
        CKEDITOR.instances["option"].focus();
        return false; // STOP the execution here
    }

    // 4. If it's NOT empty, proceed
    addOptions();
    showOptions();
    
    // 5. Clear the editor for the next one
    CKEDITOR.instances["option"].setData('');
});

    function markCorrect(index) {
        const type = $('#question_type').val();
        if (type == 1) {
            // Single choice: only one can be correct
            options.forEach((opt, i) => opt[1] = (i === index ? 1 : 0));
        } else {
            // Multiple choice: toggle
            options[index][1] = options[index][1] === 1 ? 0 : 1;
        }
        renderOptionsList();
        updatePreview();
    }

    function renderOptionsList() {
        const container = $('#option-area');
        const type = $('#question_type').val();

        if (options.length === 0) {
            container.html(`
                <div class="text-center py-4 text-muted">
                    <i class="fa fa-info-circle fa-2x mb-2"></i>
                    <p>No options added yet. Click "Add Option" to begin.</p>
                </div>
            `);
            return;
        }

        let html = '';
        options.forEach((opt, index) => {
            const isCorrect = opt[1] === 1;
            const inputType = type == 1 ? 'radio' : 'checkbox';
            
            html += `
                <div class="option-item ${isCorrect ? 'correct' : ''}">
                    <div class="drag-handle"><i class="fa fa-grip-vertical"></i></div>
                    <div class="option-check">
                        <div class="custom-control custom-${inputType}">
                            <input type="${inputType}" class="custom-control-input" id="opt_check_${index}" 
                                ${isCorrect ? 'checked' : ''} onclick="markCorrect(${index})">
                            <label class="custom-control-label" for="opt_check_${index}"></label>
                        </div>
                    </div>
                    <div class="option-content">${opt[0]}</div>
                    <div class="option-actions">
                        <button type="button" class="btn btn-sm btn-outline-danger" onclick="removeOption(${index})">
                            <i class="fa fa-trash"></i>
                        </button>
                    </div>
                </div>
            `;
        });
        container.html(html);
    }

    // Submit Handling
    $(document).on('click', '.frm_submit', function() {
        $('#action_btn').val($(this).val());
        sendData();
    });

    function sendData() {
        const type = $('#question_type').val();
        
        // Basic Validation
        if (!CKEDITOR.instances['question'].getData().trim()) {
            alert('Question text is required');
            return;
        }
        if (!$('#marks').val()) {
            alert('Marks field is required');
            return;
        }
        if (type != 3 && options.length < 2) {
            alert('Please add at least 2 options');
            return;
        }
       

        const data = {
            _token: "<?php echo e(csrf_token()); ?>",
            temp_id: $("#temp_id").val(),
            test_id: $("#test_id").val(),
            course_id: $('#course_id').val(),
            action_btn: $('#action_btn').val(),
            question_type: type,
            question: CKEDITOR.instances["question"].getData(),
            options: JSON.stringify(options),
            solution: CKEDITOR.instances["solution"].getData(),
            comment: CKEDITOR.instances["comment"].getData(),
            marks: $("#marks").val(),
            difficulty: $('#difficulty').val(),
            tags: $('#tags').val(),
            hint: $('#hint').val()
        };

        $.ajax({
            url: "<?php echo e(route('admin.test_questions.store')); ?>",
            type: 'post',
            data: data,
            success: function(response) {
                const res = JSON.parse(response);
                if (res.code == 200) {
                    window.location.replace(res.redirect_url);
                } else {
                    alert(res.message);
                }
            },
            error: function(xhr) {
                if (xhr.status === 422) {
                    const res = xhr.responseJSON;
                    alert(res.message);
                } else {
                    alert('An error occurred while saving.');
                }
            }
        });
    }

    // Handle Type change
    $('#question_type').on('change', function() {
        const type = $(this).val();
        if (type == 3) {
            $('#options-card').fadeOut();
        } else {
            $('#options-card').fadeIn();
        }
        options = []; // Reset options when type changes for simplicity or we can convert them
        renderOptionsList();
        updatePreview();
    });

</script> -->
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/stag/tadreeblms/resources/views/backend/test_questions/create.blade.php ENDPATH**/ ?>