<?php $__env->startSection('title', __('Assessments').' | '.app_name()); ?>
<?php $__env->startPush('after-styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/css/colors/switch.css')); ?>">
  <style>
.select2-container--default .select2-selection--single {
        border: 1px solid #ccc !important;
        border-radius: 5px !important;
        /* padding: 4px; */
    }
    .select2-container .select2-selection--single {
    box-sizing: border-box;
    cursor: pointer;
    display: block;
    height: 34px;
    user-select: none;
    -webkit-user-select: none;
}
.select2-container--default .select2-selection--single .select2-selection__rendered {
    color: #444;
    line-height: 30px;
}
.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 26px;
    position: absolute;
    top: 4px;
    right: 1px;
    width: 20px;
}


.select2-container--default .select2-selection--single .select2-selection__arrow {
    display: none;
    visibility: hidden;
}

/* Add custom arrow icon */
.select2-container--default .select2-selection--single {
    position: relative;
    padding-right: 30px; /* adjust if needed */
}

.select2-container--default .select2-selection--single::after {
    content: '\f078'; /* FontAwesome unicode for caret-down */
    font-family: "Font Awesome 5 Free"; /* Adjust based on your Font Awesome version */
    font-weight: 900;
    position: absolute;
    right: 10px;
    top: 50%;
    transform: translateY(-50%);
    pointer-events: none;
    color: #333; /* Icon color */
    font-size: 14px;
}

.select2-container--default.select2-container--focus .select2-selection--single {
     outline: none;
  box-shadow: 0 0 5px rgba(0, 123, 255, 0.5) !important;
  border-color: #007bff !important;
}

    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<?php
use App\Models\Course;
?>
<div class="pb-3 d-flex justify-content-between align-items-center">
    <h4 class="page-title float-left mb-0"><?php echo app('translator')->get('Course Assessment'); ?> (<?php echo e($count); ?>)</h4>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('course_create')): ?>
    <div class="">
        <?php if($user_id != NULL): ?>
        <a href="<?php echo e(route('admin.assessment_accounts.account_assignment_create', $user_id)); ?>" class="btn btn-primary"><?php echo app('translator')->get('Assignment'); ?></a>
        <?php else: ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('course_create')): ?>
        <div class="">
            <!-- <a href="<?php echo e(route('admin.assessment_accounts.create')); ?>" class="btn btn-success"><?php echo app('translator')->get('strings.backend.general.app_add_new'); ?></a> -->
            <a href="<?php echo e(route('admin.assessment_accounts.assignment_create')); ?>" class="btn add-btn"><?php echo app('translator')->get('Add Course Assessment'); ?></a>
        </div>
        <?php endif; ?>
        <?php endif; ?>
    </div>

    <?php endif; ?>
</div>
<div class="card">
    <div class="">
        <!-- <h3 class="page-title d-inline"><?php echo app('translator')->get('Course Assessment'); ?> (<?php echo e($count); ?>)</h3>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('course_create')): ?>
        <div class="float-right">
            <?php if($user_id != NULL): ?>
            <a href="<?php echo e(route('admin.assessment_accounts.account_assignment_create', $user_id)); ?>" class="btn btn-success"><?php echo app('translator')->get('Assignment'); ?></a>
            <?php else: ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('course_create')): ?>
            <div class="float-right mr-3">
               
                <a href="<?php echo e(route('admin.assessment_accounts.assignment_create')); ?>" class="btn btn-success"><?php echo app('translator')->get('Add Course Assessment'); ?></a>
            </div>
            <?php endif; ?>
            <?php endif; ?>
        </div>

        <?php endif; ?> -->


        <div class="card-body">

            <div class="row mb-3">
                <?php
                $courses = $courses = Course::has('category')->ofTeacher()->pluck('title', 'id')->prepend('Please select', '');
                ?>
                <div class="col-12 col-lg-6 form-group">
                    <label for="course_id" class="control-label"><?php echo e(trans('labels.backend.lessons.fields.course')); ?></label>
                    <select name="course_id" id="course_id" class="form-control js-example-placeholder-single select2">
                        <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>" <?php if((request('course_id') ? request('course_id') : old('course_id')) == $key): ?> selected <?php endif; ?>><?php echo e($course); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <div class="row">
            <div class="col-12">
                <div class="table-responsive">
                    <table id="myTable" class="table dt-select custom-teacher-table table-striped <?php if(auth()->user()->isAdmin()): ?> <?php if( request('show_deleted') != 1 ): ?> dt-select <?php endif; ?> <?php endif; ?>">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('Test'); ?></th>
                                <th><?php echo app('translator')->get('Duration(Minutes)'); ?></th>
                                <th><?php echo app('translator')->get('Start Time'); ?></th>
                                <th><?php echo app('translator')->get('End Time'); ?></th>
                                <th><?php echo app('translator')->get('Buffer Time(Minutes)'); ?></th>
                                <th><?php echo app('translator')->get('Verification Code'); ?></th>
                                <th><?php echo app('translator')->get('URL'); ?></th>
                                <th><?php echo app('translator')->get('Total Marks'); ?></th>
                                <th><?php echo app('translator')->get('Secured Marks'); ?></th>
                                <?php if($type == 1): ?>
                                <th><?php echo app('translator')->get('Details'); ?></th>
                                <?php endif; ?>
                                <th><?php echo app('translator')->get('Action'); ?></th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__currentLoopData = $assignments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td> <?php echo e($value->title); ?> </td>
                                <td> <?php echo e($value->duration); ?> </td>
                                <td> <?php echo e($value->start_time); ?> </td>
                                <td> <?php echo e($value->end_time); ?> </td>
                                <td> <?php echo e($value->buffer_time); ?> </td>
                                <td> <?php echo e($value->verify_code); ?> </td>
                                <td> <?php echo e(route('online_assessment', ['assignment' => $value->url_code , 'verify_code' => $value->verify_code ])); ?> </td>
                                <td> <?php echo e($value->total_marks); ?> </td>
                                <td> <?php echo e($value->secured_marks); ?> </td>
                                <?php if($type == 1): ?>
                                <td>
                                    <a href="<?php echo e(route('admin.assessment_accounts.assignment_question_answers', ['user_id'=>$user_id, 'assignment_id'=>$value->id])); ?>" class="btn btn-xs btn-primary mb-1"><i class="fa fa-tasks"></i></a>
                                </td>
                                <?php endif; ?>
                                <td>
                                    <a data-method="delete" 
                                        data-trans-button-cancel="<?php echo e(__('buttons.general.cancel')); ?>" 
                                        data-trans-button-confirm="<?php echo e(__('buttons.general.crud.delete')); ?>" 
                                        data-trans-title="<?php echo e(__('strings.backend.general.are_you_sure')); ?>" 
                                        class="btn btn-xs btn-danger text-white mb-1" 
                                        style="cursor:pointer;" 
                                        onclick="if(confirm('<?php echo e(__('strings.backend.general.are_you_sure')); ?>')) { $(this).find('form').submit(); }">
                                        
                                            <i class="fa fa-trash" 
                                            data-toggle="tooltip" 
                                            data-placement="top" 
                                            title="<?php echo e(__('buttons.general.crud.delete')); ?>"></i>

                                            <form action="<?php echo e(route('admin.assessment_accounts.assignments_delete', ['id' => $value->id])); ?>" 
                                                method="POST" 
                                                name="delete_item" 
                                                style="display:none">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('GET'); ?>
                                            </form>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>


        </div>


        
   
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>
<script>
    $(document).ready(function() {
        $('#myTable').dataTable({
            "paginate": true,
            "sort": true,
            "language": {
                "emptyTable": "No Data Is Available.",
                search:"",
   
            },
            "order": [
                [0, "desc"]
            ],
            dom:  "<'table-controls'lfB>" +
                     "<'table-responsive't>" +
                     "<'d-flex justify-content-between align-items-center mt-3'ip><'actions'>",
            // buttons: [{
            //         extend: 'csv',
            //         exportOptions: {
            //             columns: [1, 2, 3, 4]
            //         }
            //     },
            //     {
            //         extend: 'pdf',
            //         exportOptions: {
            //             columns: [1, 2, 3, 4],
            //         }
            //     },
            //     'colvis'
            // ],
             buttons: [
    {
        extend: 'collection',
        text: '<i class="fa fa-download icon-styles"></i>',
        className: '',
        buttons: [
            {
                extend: 'csv',
                text: 'CSV',
                exportOptions: {
                    columns: [1, 2, 3, 4, 5]
                }
            },
            {
                extend: 'pdf',
                text: 'PDF',
                exportOptions: {
                    columns: [1, 2, 3, 4, 5]
                }
            }
        ]
    },
      {extend: 'colvis',
    text: '<i class="fa fa-eye icon-styles" aria-hidden="true"></i>',
    className: ''},
],
             initComplete: function () {
                    let $searchInput = $('#myTable_filter input[type="search"]');
    $searchInput
        .addClass('custom-search')
        .wrap('<div class="search-wrapper position-relative d-inline-block"></div>')
        .after('<i class="fa fa-search search-icon"></i>');

    $('#myTable_length select').addClass('form-select form-select-sm custom-entries');
                },
                  
        });
    });




    $(document).on('change', '#course_id', function(e) {
        var course_id = $(this).val();
        window.location.href = "<?php echo e(url('user/assignments')); ?>" + "?course_id=" + course_id
    });
</script>

<?php $__env->stopPush(); ?>
<?php echo $__env->make('backend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/stag/tadreeblms/resources/views/backend/assessment_accounts/assignments.blade.php ENDPATH**/ ?>