<?php $request = app('Illuminate\Http\Request'); ?>


<?php $__env->startSection('title', 'Department'.' | '.app_name()); ?>
<?php $__env->startPush('after-styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/colors/switch.css')); ?>">
       <style>
        .dropdown-menu{
            padding: 5px;
        }
      .dropdown-item{
        border-bottom: none;
      }
   
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<div>

    <div class="pb-3">
        <div class="d-flex justify-content-between">
            <h4><?php echo app('translator')->get('Department'); ?></h4>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('blog_create')): ?>
                <div>
                    <a href="<?php echo e(route('admin.department.create')); ?>" class="btn add-btn">
                        <?php echo app('translator')->get('Add Department'); ?>
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <div class="card">
        <div class="card-body">

            <div class="row">

                <!-- Import Internal Trainee -->
                <div class="col-6 mb-2">
                    <h6><?php echo app('translator')->get('Import Internal Trainee'); ?></h6>

                    <form method="POST"
                          action="<?php echo e(route('admin.department.add.import')); ?>"
                          enctype="multipart/form-data">

                        <?php echo csrf_field(); ?>

                        <div class="d-flex">

                            <div class="custom-file-upload-wrapper" style="margin-top:18px;">
                                <input type="file"
                                       name="file"
                                       id="importFile"
                                       class="custom-file-input"
                                       required>

                                <label for="importFile" class="custom-file-label">
                                    <i class="fa fa-upload mr-1"></i> Choose a file
                                </label>
                            </div>

                            <button type="submit"
                                    class="btn btn-primary ml-3"
                                    name="submit"
                                    value="submit">
                                <?php echo app('translator')->get('Import'); ?>
                            </button>

                        </div>

                    </form>
                </div>

                <!-- List Table -->
                <div class="col-12 mt-4">

                    <div class="d-block">
                        <ul class="list-inline">
                            <li class="list-inline-item">
                                <a href="<?php echo e(route('admin.department.index')); ?>"
                                   style="<?php echo e(request('show_deleted') == 1 ? '' : 'font-weight: 700'); ?>">
                                    <?php echo e(trans('labels.general.all')); ?>

                                </a>
                            </li>
                            |
                            <li class="list-inline-item">
                                <a href="<?php echo e(route('admin.department.index')); ?>?show_deleted=1"
                                   style="<?php echo e(request('show_deleted') == 1 ? 'font-weight: 700' : ''); ?>">
                                    <?php echo e(trans('labels.general.trash')); ?>

                                </a>
                            </li>
                        </ul>
                    </div>

                    <table id="myTable" class="table custom-teacher-table table-striped">
                        <thead>
                        <tr>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('lesson_delete')): ?>
                                <?php if(request('show_deleted') != 1): ?>
                                    <th style="text-align:center;">
                                        <input type="checkbox" id="select-all" class="mass">
                                    </th>
                                <?php endif; ?>
                            <?php endif; ?>

                            <th><?php echo app('translator')->get('labels.general.sr_no'); ?></th>
                            <th><?php echo app('translator')->get('labels.backend.pages.fields.title'); ?></th>
                            <th><?php echo app('translator')->get('labels.backend.pages.fields.status'); ?></th>
                            <th><?php echo app('translator')->get('labels.backend.pages.fields.created'); ?></th>

                            <th style="text-align:center;">
                                <?php echo app('translator')->get('strings.backend.general.actions'); ?>
                            </th>
                        </tr>
                        </thead>

                        <tbody></tbody>
                    </table>

                </div>

            </div>

        </div>
    </div>

</div>

<?php $__env->stopSection(); ?>


<?php $__env->startPush('after-scripts'); ?>
    <script>

        $(document).ready(function () {
            var route = '<?php echo e(route('admin.department.get_data')); ?>';

            <?php if(request('show_deleted') == 1): ?>
                route = '<?php echo e(route('admin.department.get_data',['show_deleted' => 1])); ?>';
            <?php endif; ?>
            $('#myTable').DataTable({
                processing: true,
                serverSide: true,
                iDisplayLength: 10,
                retrieve: true,
                dom: "<'table-controls'lfB>" +
                     "<'table-responsive't>" +
                     "<'d-flex justify-content-between align-items-center mt-3'ip><'actions'>",
                 buttons: [
    {
        extend: 'collection',
        text: '<i class="fa fa-download icon-styles"></i>',
        className: '',
        buttons: [
            {
                extend: 'csv',
                text: 'CSV',
                exportOptions: {
                    columns: [1, 2, 3, 4, 5]
                }
            },
            {
                extend: 'pdf',
                text: 'PDF',
                exportOptions: {
                    columns: [1, 2, 3, 4, 5]
                }
            }
        ]
    },
      {extend: 'colvis',
    text: '<i class="fa fa-eye icon-styles" aria-hidden="true"></i>',
    className: ''},
],
                ajax: route,
                columns: [
                        <?php if(request('show_deleted') != 1): ?>
                    {
                        "data": function (data) {
                            return '<input type="checkbox" class="single" name="id[]" value="' + data.id + '" />';
                        }, "orderable": false, "searchable": false, "name": "id"
                    },
                        <?php endif; ?>
                    {data: "DT_RowIndex", name: 'DT_RowIndex', searchable: false, orderable: false},
                    {data: "title", name: 'title'},
                    {data: "status", name: 'status'},
                    {data: "created", name: "created"},
                    {data: "actions", name: "actions"}
                ],
                <?php if(request('show_deleted') != 1): ?>
                columnDefs: [
                    {"width": "5%", "targets": 0},
                    {"className": "text-center", "targets": [0]}
                ],
                <?php endif; ?>
initComplete: function () {
                   let $searchInput = $('#myTable_filter input[type="search"]');
    $searchInput
        .addClass('custom-search')
        .wrap('<div class="search-wrapper position-relative d-inline-block"></div>')
        .after('<i class="fa fa-search search-icon"></i>');

    $('#myTable_length select').addClass('form-select form-select-sm custom-entries');
                },

                createdRow: function (row, data, dataIndex) {
                    $(row).attr('data-entry-id', data.id);
                },
                language:{
                    url : "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/<?php echo e($locale_full_name); ?>.json",
                    buttons :{
                        colvis : '<?php echo e(trans("datatable.colvis")); ?>',
                        pdf : '<?php echo e(trans("datatable.pdf")); ?>',
                        csv : '<?php echo e(trans("datatable.csv")); ?>',
                    },
                    search:"",
    //                  paginate: {
    //     previous: '<i class="fa fa-angle-left"></i>',
    //     next: '<i class="fa fa-angle-right"></i>'
    // },
                }
            });


            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('blog_delete')): ?>
            <?php if(request('show_deleted') != 1): ?>
            $('.actions').html('<a href="' + '<?php echo e(route('admin.department.mass_destroy')); ?>' + '" class="btn btn-xs btn-danger js-delete-selected" style="margin-top:0.755em;margin-left: 20px;">Delete selected</a>');
            <?php endif; ?>
            <?php endif; ?>

        });

    </script>
    <script>
    document.querySelectorAll('.custom-file-input').forEach(function(input) {
        input.addEventListener('change', function(e) {
            const label = input.nextElementSibling;
            const fileName = e.target.files.length > 0 ? e.target.files[0].name : 'Choose a file';
            label.innerHTML = '<i class="fa fa-upload mr-1"></i> ' + fileName;
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('backend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/stag/tadreeblms/resources/views/backend/department/index.blade.php ENDPATH**/ ?>