<?php $__env->startSection('title', 'Trainee'.' | '.app_name()); ?>
<?php $__env->startPush('after-styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/colors/switch.css')); ?>">
    <style>
        .filter-form {
            position: absolute;
            width: 260px;
            left: 157px;
            top: 32px;
            z-index: 9999;
        }
        select.sel.form-control {
            width: 65%;
            display: inline-block;
        }
        .dataTables_wrapper .dataTables_filter {
            float: left;
            text-align: left;
            margin-left: 40%;
        }
        .enroll-tab-btn {
            cursor: pointer;
            padding: 8px 16px;
            border: 1px solid #ddd;
            background: #f8f9fa;
            border-radius: 4px 4px 0 0;
            margin-right: 4px;
        }
        .enroll-tab-btn.active {
            background: #fff;
            border-bottom-color: #fff;
            font-weight: 600;
        }
        .enroll-tab-content {
            display: none;
        }
        .enroll-tab-content.active {
            display: block;
        }
        .select2-container--default .select2-selection--multiple {
            border: 1px solid #ced4da !important;
            border-radius: .25rem !important;
            min-height: 38px;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>

<div class="pb-3 d-flex justify-content-between align-items-center">
        <h4 class="">Enrolled Trainee [<?php echo e(CustomHelper::getCourseName($course_id)); ?>]</h4>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('course_create')): ?>
        <div class="">
            <button type="button" class="btn btn-success" data-toggle="modal" data-target="#enrollUsersModal">
                + Enroll Users
            </button>
        </div>
    <?php endif; ?>
</div>
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-12">
                    <div class="table-responsive">
                        <div class="d-block">
                            <ul class="list-inline">
                                <li class="list-inline-item">
                                    <a href="<?php echo e(route('admin.employee.index')); ?>"
                                       style="<?php echo e(request('show_deleted') == 1 ? '' : 'font-weight: 700'); ?>"><?php echo e(trans('labels.general.all')); ?></a>
                                </li>
                                |
                                <li class="list-inline-item">
                                    <a href="<?php echo e(route('admin.employee.index')); ?>?show_deleted=1"
                                       style="<?php echo e(request('show_deleted') == 1 ? 'font-weight: 700' : ''); ?>"><?php echo e(trans('labels.general.trash')); ?></a>
                                </li>
                            </ul>
                        </div>


                        <table id="myTable"
                               class="table dt-select custom-teacher-table table-striped <?php if(auth()->user()->isAdmin()): ?> <?php if( request('show_deleted') != 1 ): ?> dt-select <?php endif; ?> <?php endif; ?>" style="width: 1300px;">
                            <thead>
                            <tr>

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('category_delete')): ?>
                                    <?php if( request('show_deleted') != 1 ): ?>
                                        <th style="text-align:center;"><input type="checkbox" class="mass"
                                                                              id="select-all"/>
                                        </th><?php endif; ?>
                                <?php endif; ?>
                                <th>Trainee Type</th>
                                <th><?php echo app('translator')->get('labels.backend.teachers.fields.email'); ?></th>
                                <th>Enrolled Date</th>
                                <th><?php echo app('translator')->get('labels.backend.teachers.fields.status'); ?></th>
                                <th>Completed Status</th>
                                <th>Feedback</th>
                                <th>Issue Certificate</th>
                                <th>Track Employee</th>
                                <th>Track Percentage</th>
                                <!--
                                <?php if( request('show_deleted') == 1 ): ?>
                                    <th>&nbsp; <?php echo app('translator')->get('strings.backend.general.actions'); ?></th>
                                <?php else: ?>
                                    <th>&nbsp; <?php echo app('translator')->get('strings.backend.general.actions'); ?></th>
                                <?php endif; ?>
                                -->
                            </tr>
                            </thead>

                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>


            </div>
        </div>
    </div>


<div class="modal fade" id="enrollUsersModal" tabindex="-1" role="dialog" aria-labelledby="enrollUsersModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="enrollUsersModalLabel">Enroll Users</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div id="enroll-alert" class="alert d-none"></div>

                
                <div class="mb-3" style="border-bottom: 1px solid #ddd;">
                    <span class="enroll-tab-btn active" data-tab="single-user">Single User</span>
                    <span class="enroll-tab-btn" data-tab="department">Entire Department</span>
                </div>

                <form id="enrollUsersForm">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="course_id" value="<?php echo e($course_id); ?>">

                    
                    <div class="enroll-tab-content active" id="tab-single-user">
                        <div class="form-group">
                            <label for="enroll_teachers">Select Users <span class="text-danger">*</span></label>
                            <select name="teachers[]" id="enroll_teachers" class="form-control select2" multiple style="width: 100%;">
                                <?php $__currentLoopData = $teachers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($key); ?>"><?php echo e($name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    
                    <div class="enroll-tab-content" id="tab-department">
                        <div class="form-group">
                            <label for="enroll_department">Select Department <span class="text-danger">*</span></label>
                            <select name="department_id" id="enroll_department" class="form-control select2" style="width: 100%;">
                                <option value="">Select One</option>
                                <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($row->id); ?>"><?php echo e($row->title); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-success" id="btnEnrollSubmit">
                    <span class="spinner-border spinner-border-sm d-none" id="enrollSpinner" role="status"></span>
                    Enroll
                </button>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>
    <script>

        $(document).ready(function () {

            // Initialize Select2 inside modal
            $('#enrollUsersModal').on('shown.bs.modal', function () {
                $('#enroll_teachers').select2({
                    dropdownParent: $('#enrollUsersModal'),
                    placeholder: 'Search and select users...',
                    allowClear: true
                });
                $('#enroll_department').select2({
                    dropdownParent: $('#enrollUsersModal'),
                    placeholder: 'Select a department',
                    allowClear: true
                });
            });

            // Tab switching
            $(document).on('click', '.enroll-tab-btn', function () {
                $('.enroll-tab-btn').removeClass('active');
                $(this).addClass('active');
                var tab = $(this).data('tab');
                $('.enroll-tab-content').removeClass('active');
                $('#tab-' + tab).addClass('active');

                // Clear the other tab's selection
                if (tab === 'single-user') {
                    $('#enroll_department').val('').trigger('change');
                } else {
                    $('#enroll_teachers').val([]).trigger('change');
                }
            });

            // Submit enrollment
            $(document).on('click', '#btnEnrollSubmit', function () {
                var $btn = $(this);
                var $spinner = $('#enrollSpinner');
                var $alert = $('#enroll-alert');
                $alert.addClass('d-none').removeClass('alert-success alert-warning alert-danger');

                // Validate
                var activeTab = $('.enroll-tab-btn.active').data('tab');
                var teachers = $('#enroll_teachers').val();
                var department = $('#enroll_department').val();

                if (activeTab === 'single-user' && (!teachers || teachers.length === 0)) {
                    $alert.removeClass('d-none').addClass('alert-danger').text('Please select at least one user.');
                    return;
                }

                if (activeTab === 'department' && !department) {
                    $alert.removeClass('d-none').addClass('alert-danger').text('Please select a department.');
                    return;
                }

                // Build form data
                var formData = new FormData($('#enrollUsersForm')[0]);

                // Remove irrelevant field based on active tab
                if (activeTab === 'single-user') {
                    formData.delete('department_id');
                } else {
                    formData.delete('teachers[]');
                }

                $btn.prop('disabled', true);
                $spinner.removeClass('d-none');

                $.ajax({
                    url: '<?php echo e(route("admin.enroll_users")); ?>',
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function (response) {
                        var msg = response.enrolled + ' user(s) enrolled successfully.';
                        var alertClass = 'alert-success';

                        if (response.already_enrolled > 0) {
                            msg += '\n' + response.already_enrolled + ' user(s) already enrolled: ' + response.already_enrolled_names.join(', ');
                            alertClass = response.enrolled > 0 ? 'alert-warning' : 'alert-warning';
                        }

                        if (response.skipped_inactive > 0) {
                            msg += '\n' + response.skipped_inactive + ' inactive user(s) skipped.';
                        }

                        $alert.removeClass('d-none').addClass(alertClass).css('white-space', 'pre-line').text(msg);

                        // Reload DataTable
                        if (response.enrolled > 0) {
                            $('#myTable').DataTable().ajax.reload(null, false);
                        }

                        // Reset form
                        $('#enroll_teachers').val([]).trigger('change');
                        $('#enroll_department').val('').trigger('change');
                    },
                    error: function (xhr) {
                        var errMsg = 'An error occurred.';
                        if (xhr.responseJSON) {
                            if (xhr.responseJSON.errors) {
                                var errors = xhr.responseJSON.errors;
                                errMsg = Object.values(errors).flat().join('\n');
                            } else if (xhr.responseJSON.error) {
                                errMsg = xhr.responseJSON.error;
                            }
                        }
                        $alert.removeClass('d-none').addClass('alert-danger').css('white-space', 'pre-line').text(errMsg);
                    },
                    complete: function () {
                        $btn.prop('disabled', false);
                        $spinner.addClass('d-none');
                    }
                });
            });

            // Reset modal on close
            $('#enrollUsersModal').on('hidden.bs.modal', function () {
                $('#enroll-alert').addClass('d-none');
                $('#enroll_teachers').val([]).trigger('change');
                $('#enroll_department').val('').trigger('change');
                $('.enroll-tab-btn').removeClass('active').first().addClass('active');
                $('.enroll-tab-content').removeClass('active').first().addClass('active');
            });

            var route = '<?php echo e(route('admin.employee.enrolled_get_data',[ $course_id ,0])); ?>';

            <?php if(request('show_deleted') == 1): ?>
                route = '<?php echo e(route('admin.employee.enrolled_get_data',[ $course_id ,1])); ?>';
            <?php endif; ?>

           var table = $('#myTable').DataTable({
                processing: true,
                serverSide: true,
                iDisplayLength: 10,
                retrieve: true,
                dom: "<'table-controls'lfB>" +
                     "<'table-responsive't>" +
                     "<'d-flex justify-content-end align-items-center mt-3'p><'actions'>",
                 buttons: [
    {
        extend: 'collection',
        text: '<i class="fa fa-download icon-styles"></i>',
        className: '',
        buttons: [
            {
                extend: 'csv',
                text: 'CSV',
                exportOptions: {
                    columns: [1, 2, 3, 4, 5]
                }
            },
            {
                extend: 'pdf',
                text: 'PDF',
                exportOptions: {
                    columns: [1, 2, 3, 4, 5]
                }
            }
        ]
    },
      {extend: 'colvis',
    text: '<i class="fa fa-eye icon-styles" aria-hidden="true"></i>',
    className: ''},
],
                ajax: {
                    url:route,
                },
                columns: [
                        <?php if(request('show_deleted') != 1): ?>
                    {
                        "data": function (data) {
                            return '<input type="checkbox" class="single" name="id[]" value="' + data.id + '" />';
                        }, "orderable": false, "searchable": false, "name": "id"
                    },
                        <?php endif; ?>
                    //{data: "DT_RowIndex", name: 'DT_RowIndex', searchable: false, orderable:false},
                    {data: "trainee_type", name: 'trainee_type'},
                    {data: "email", name: 'email'},
                    {data: "enrolled_date", name: 'enrolled_date'},
                    {data: "status", name: 'status'},
                    {data: "course_completed", name: 'course_completed'},
                    {data: "feedback", name: 'feedback'},
                    {data: "issue_certificate", name: 'issue_certificate'},
                    {data: "track_employee", name: "track_employee"},
                    {data: "percentage", name: "percentage"},
                    //{data: "actions", name: 'actions'}
                ],
                <?php if(request('show_deleted') != 1): ?>
                columnDefs: [
                    {"width": "5%", "targets": 0},
                    {"className": "text-center", "targets": [0]}
                ],
                <?php endif; ?>

                createdRow: function (row, data, dataIndex) {
                    $(row).attr('data-entry-id', data.id);
                },
                initComplete: function () {
                    let $searchInput = $('#myTable_filter input[type="search"]');
    $searchInput
        .addClass('custom-search')
        .wrap('<div class="search-wrapper position-relative d-inline-block"></div>')
        .after('<i class="fa fa-search search-icon"></i>');

    $('#myTable_length select').addClass('form-select form-select-sm custom-entries');
                },
                language:{
                    url : "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/<?php echo e($locale_full_name); ?>.json",
                    buttons :{
                        colvis : '<?php echo e(trans("datatable.colvis")); ?>',
                        pdf : '<?php echo e(trans("datatable.pdf")); ?>',
                        csv : '<?php echo e(trans("datatable.csv")); ?>',
                    },
                    search:"",
                }

            });
            <?php if(auth()->user()->isAdmin()): ?>
            $('.actions').html('<a href="' + '<?php echo e(route('admin.teachers.mass_destroy')); ?>' + '" class="btn btn-xs btn-danger js-delete-selected" style="margin-top:0.755em;margin-left: 20px;">Delete selected</a>');
            <?php endif; ?>



        });

    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/stag/tadreeblms/resources/views/backend/employee/enrolled_employee.blade.php ENDPATH**/ ?>