<?php

namespace Spatie\Backup\Helpers;

use Illuminate\Console\Command;

/**
 * @mixin \Illuminate\Console\Concerns\InteractsWithIO
 *
 * @phpstan-ignore mixin.trait
 */
class ConsoleOutput
{
    protected ?Command $command = null;

    public function setCommand(Command $command): void
    {
        $this->command = $command;
    }

    /** @param array<int, mixed> $arguments */
    public function __call(string $method, array $arguments): void
    {
        if (! $this->command) {
            return;
        }

        $this->command->$method($arguments[0]);
    }
}
